# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.2.5 on 2025-09-02 13:19

from django.db import migrations


def remove_migrated_addons(apps, schema_editor) -> None:
    Addon = apps.get_model("addons", "Addon")
    # This removes missing add-on from weblate/trans/migrations/0046_component_file_format_params.py
    Addon.objects.filter(name="weblate.xml.customize").delete()


class Migration(migrations.Migration):
    dependencies = [
        ("addons", "0008_alter_addonactivitylog_event_alter_event_event"),
        ("trans", "0046_component_file_format_params"),
    ]

    operations = [
        migrations.RunPython(
            remove_migrated_addons, migrations.RunPython.noop, elidable=True
        ),
    ]
