# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later
# Generated by Django 5.2.5 on 2025-10-06 09:09

from django.db import migrations

from weblate.addons.events import AddonEvent
from weblate.addons.utils import adjust_addon_events


def add_autotranslate_change_event(apps, schema_editor) -> None:
    adjust_addon_events(
        apps,
        schema_editor,
        ["weblate.autotranslate.autotranslate"],
        [AddonEvent.EVENT_CHANGE],
        [],
    )


class Migration(migrations.Migration):
    dependencies = [
        ("addons", "0011_addonactivitylog_pending"),
    ]

    operations = [
        migrations.RunPython(
            add_autotranslate_change_event, migrations.RunPython.noop, elidable=True
        ),
    ]
