# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.9 on 2024-02-15 07:43

import django.db.models.deletion
from django.db import migrations, models

import weblate.trans.fields


class Migration(migrations.Migration):
    dependencies = [
        ("weblate_auth", "0002_squashed_weblate_5"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="autogroup",
            options={
                "verbose_name": "Automatic team assignment",
                "verbose_name_plural": "Automatic team assignments",
            },
        ),
        migrations.AlterField(
            model_name="autogroup",
            name="group",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="weblate_auth.group",
                verbose_name="Team to assign",
            ),
        ),
        migrations.AlterField(
            model_name="autogroup",
            name="match",
            field=weblate.trans.fields.RegexField(
                default="^$",
                help_text="Users with e-mail addresses found to match will be added to this team.",
                max_length=200,
                verbose_name="Regular expression for e-mail address",
            ),
        ),
        migrations.AlterField(
            model_name="group",
            name="internal",
            field=models.BooleanField(
                default=False, verbose_name="Internal Weblate team"
            ),
        ),
        migrations.AlterField(
            model_name="group",
            name="roles",
            field=models.ManyToManyField(
                blank=True,
                help_text="Choose roles granted to this team.",
                to="weblate_auth.role",
                verbose_name="Roles",
            ),
        ),
    ]
