# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.9 on 2024-02-19 09:08

from django.db import migrations

from weblate.auth.data import GROUPS


def migrate_teams(apps, schema_editor) -> None:
    Group = apps.get_model("weblate_auth", "Group")
    for name, _roles, _project_selection in GROUPS:
        offset = 2
        instances = list(
            Group.objects.filter(
                name=name,
                internal=True,
                defining_project=None,
            )
        )
        while len(instances) > 1:
            instance = instances.pop()
            newname = f"{name} ({offset})"
            while Group.objects.filter(
                name=newname, internal=True, defining_project=None
            ).exists():
                offset += 1
                newname = f"{name} ({offset})"

            print(
                f"Found duplicate team<{instance.pk}>: {name!r}, renaming to {newname!r}"
            )
            instance.name = newname
            instance.save(update_fields=["name"])


class Migration(migrations.Migration):
    dependencies = [
        ("weblate_auth", "0002_squashed_weblate_5"),
    ]

    operations = [
        migrations.RunPython(migrate_teams, migrations.RunPython.noop, elidable=True),
    ]
