# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.5 on 2023-09-18 08:15

import django.core.serializers.json
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    replaces = [
        ("billing", "0001_squashed_0020_auto_20200320_1007"),
        ("billing", "0002_remove_billing_grace_period"),
        ("billing", "0003_auto_20201118_1217"),
        ("billing", "0004_replace_expired"),
        ("billing", "0005_auto_20210512_1955"),
        ("billing", "0006_alter_billing_payment_alter_invoice_payment"),
        ("billing", "0007_billing_payment_new"),
        ("billing", "0008_jsonfield"),
        ("billing", "0009_remove_billing_payment_remove_invoice_payment"),
        ("billing", "0010_rename_payment_new_billing_payment_and_more"),
        ("billing", "0011_alter_billing_payment"),
        ("billing", "0012_alter_billing_expiry_alter_billing_removal"),
    ]

    initial = True

    dependencies = [
        ("trans", "0001_squashed_weblate_5"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Plan",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("price", models.IntegerField(default=0)),
                ("limit_strings", models.IntegerField(default=0)),
                ("limit_languages", models.IntegerField(default=0)),
                ("limit_projects", models.IntegerField(default=0)),
                ("yearly_price", models.IntegerField(default=0)),
                ("display_limit_languages", models.IntegerField(default=0)),
                ("display_limit_projects", models.IntegerField(default=0)),
                ("display_limit_strings", models.IntegerField(default=0)),
                ("change_access_control", models.BooleanField(default=True)),
                ("public", models.BooleanField(default=False)),
                ("slug", models.SlugField(max_length=100, unique=True)),
            ],
            options={
                "verbose_name": "Billing plan",
                "verbose_name_plural": "Billing plans",
            },
        ),
        migrations.CreateModel(
            name="Billing",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "plan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="billing.plan",
                        verbose_name="Billing plan",
                    ),
                ),
                (
                    "projects",
                    models.ManyToManyField(
                        blank=True, to="trans.project", verbose_name="Billed projects"
                    ),
                ),
                (
                    "state",
                    models.IntegerField(
                        choices=[(0, "Active"), (1, "Trial"), (3, "Terminated")],
                        default=0,
                        verbose_name="Billing state",
                    ),
                ),
                (
                    "in_limits",
                    models.BooleanField(
                        default=True, editable=False, verbose_name="In limits"
                    ),
                ),
                (
                    "paid",
                    models.BooleanField(
                        default=True, editable=False, verbose_name="Paid"
                    ),
                ),
                (
                    "expiry",
                    models.DateTimeField(
                        blank=True,
                        help_text="After expiry removal with 15 days grace period is scheduled.",
                        null=True,
                        verbose_name="Trial expiry date",
                    ),
                ),
                (
                    "owners",
                    models.ManyToManyField(
                        blank=True,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Billing owners",
                    ),
                ),
                (
                    "removal",
                    models.DateTimeField(
                        blank=True,
                        help_text="This is automatically set after trial expiry.",
                        null=True,
                        verbose_name="Scheduled removal",
                    ),
                ),
                (
                    "payment",
                    models.JSONField(
                        default=dict,
                        editable=False,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
            ],
            options={
                "verbose_name": "Customer billing",
                "verbose_name_plural": "Customer billings",
            },
        ),
        migrations.CreateModel(
            name="Invoice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("start", models.DateField()),
                ("end", models.DateField()),
                (
                    "currency",
                    models.IntegerField(
                        choices=[(0, "EUR"), (1, "mBTC"), (2, "USD"), (3, "CZK")],
                        default=0,
                    ),
                ),
                ("ref", models.CharField(blank=True, max_length=50)),
                ("note", models.TextField(blank=True)),
                (
                    "billing",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="billing.billing",
                    ),
                ),
                ("amount", models.FloatField()),
                ("payment", models.JSONField(default=dict, editable=False)),
            ],
            options={
                "verbose_name": "Invoice",
                "verbose_name_plural": "Invoices",
            },
        ),
    ]
