# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.2.6 on 2025-10-06 08:11

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("billing", "0003_invoice_created"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AlterField(
            model_name="invoice",
            name="billing",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.RESTRICT, to="billing.billing"
            ),
        ),
        migrations.CreateModel(
            name="BillingLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="Timestamp"
                    ),
                ),
                (
                    "event",
                    models.IntegerField(
                        choices=[
                            (1, "Outbound e-mail"),
                            (2, "Trial expired"),
                            (3, "Projects removed"),
                            (4, "Payment received"),
                            (5, "Unpaid billing"),
                            (6, "Created billing"),
                            (7, "Disabled recurring payment"),
                        ],
                        verbose_name="Billing event",
                    ),
                ),
                ("summary", models.CharField(max_length=200, verbose_name="Summary")),
                (
                    "billing",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        to="billing.billing",
                        verbose_name="Billing",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.RESTRICT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
