# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# We ignore some words which are usually untranslated
import string

IGNORE_WORDS = {
    "abc",
    "accelerator",
    "account",
    "action",
    "actions",
    "active",
    "add",
    "addons",
    "address",
    "admin",
    "administration",
    "administrator",
    "aes",
    "africa",
    "agenda",
    "agent",
    "alarm",
    "album",
    "alias",
    "aliases",
    "aliasing",
    "alibaba",
    "alt",
    "altitude",
    "amazon",
    "amex",
    "android",
    "antialias",
    "antialiasing",
    "apertium",
    "api",
    "applet",
    "appliance",
    "appliances",
    "apt",
    "aptitude",
    "area",
    "array",
    "artica",
    "artist",
    "artwork",
    "async",
    "atom",
    "attribute",
    "attribution",
    "audio",
    "auth",
    "authentication",
    "author",
    "auto",
    "autostart",
    "avatar",
    "azure",
    "backend",
    "backspace",
    "backup",
    "badge",
    "balance",
    "baltic",
    "bank",
    "banner",
    "bar",
    "baseball",
    "battery",
    "bazaar",
    "begin",
    "beta",
    "bios",
    "bit",
    "bitbucket",
    "bitcoin",
    "bitcoins",
    "bitmap",
    "bitmaps",
    "bitnami",
    "bitrate",
    "block",
    "blog",
    "bluetooth",
    "bool",
    "boolean",
    "boot",
    "bootloader",
    "box",
    "branch",
    "broadcast",
    "browser",
    "bsd",
    "buffer",
    "byte",
    "bytes",
    "bzip",
    "cable",
    "cache",
    "caps",
    "captcha",
    "cardinality",
    "cdrom",
    "celery",
    "celsius",
    "classic",
    "click",
    "client",
    "clipboard",
    "cloud",
    "club",
    "cmd",
    "cockpit",
    "code",
    "codec",
    "collation",
    "color",
    "command",
    "commit",
    "component",
    "components",
    "compression",
    "conductor",
    "configuration",
    "console",
    "contact",
    "contacts",
    "context",
    "control",
    "cookie",
    "cookies",
    "copyright",
    "core",
    "creation",
    "criteria",
    "crypt",
    "csd",
    "csv",
    "ctrl",
    "cvs",
    "cyrillic",
    "danda",
    "dashboard",
    "data",
    "database",
    "databases",
    "date",
    "datum",
    "dbm",
    "debconf",
    "debian",
    "debug",
    "deepl",
    "default",
    "definition",
    "del",
    "delete",
    "demo",
    "description",
    "design",
    "designer",
    "desktop",
    "destination",
    "detail",
    "details",
    "devanagari",
    "developer",
    "devscripts",
    "dialog",
    "diaspora",
    "diners",
    "ding",
    "diplomat",
    "direction",
    "directory",
    "disc",
    "distance",
    "distribution",
    "distro",
    "dns",
    "doc",
    "docs",
    "doctor",
    "document",
    "documentation",
    "dollar",
    "download",
    "downloads",
    "doxygen",
    "dpi",
    "dpkg",
    "drizzle",
    "droid",
    "dropbox",
    "dtd",
    "dummy",
    "dump",
    "edition",
    "editor",
    "eib",
    "ellipsis",
    "email",
    "end",
    "engine",
    "engines",
    "enter",
    "enterprise",
    "enum",
    "error",
    "esc",
    "escape",
    "eta",
    "ethereum",
    "ethernet",
    "event",
    "events",
    "excel",
    "exchange",
    "expert",
    "explore",
    "export",
    "express",
    "expression",
    "extension",
    "extra",
    "extras",
    "facebook",
    "false",
    "fame",
    "fanfare",
    "farm",
    "fauna",
    "fax",
    "fediverse",
    "fedora",
    "feeds",
    "feet",
    "file",
    "files",
    "filter",
    "filters",
    "finalisation",
    "finance",
    "fingerprint",
    "firefox",
    "firewall",
    "firmware",
    "fjord",
    "flash",
    "flattr",
    "float",
    "flora",
    "font",
    "form",
    "format",
    "forum",
    "freemind",
    "freeplane",
    "frequency",
    "frontend",
    "full",
    "fulltext",
    "function",
    "gamma",
    "gammu",
    "gas",
    "general",
    "genre",
    "gentoo",
    "geo",
    "geocache",
    "geocaching",
    "geometry",
    "get",
    "gettext",
    "ghz",
    "gib",
    "git",
    "gitea",
    "github",
    "gitlab",
    "global",
    "glosbe",
    "gmail",
    "gnu",
    "golf",
    "google",
    "gpl",
    "gps",
    "gpt",
    "gpx",
    "grant",
    "graphic",
    "graphics",
    "gratis",
    "greeter",
    "gtk",
    "gvim",
    "gzip",
    "hack",
    "hacks",
    "hall",
    "handle",
    "handler",
    "hardware",
    "hash",
    "hashed",
    "hdmi",
    "headset",
    "help",
    "hex",
    "histogram",
    "hmpf",
    "home",
    "homebrew",
    "homepage",
    "honeypot",
    "hong",
    "hook",
    "horizontal",
    "horror",
    "host",
    "hosted",
    "hostel",
    "hosting",
    "hostname",
    "hotel",
    "hpa",
    "html",
    "http",
    "https",
    "hut",
    "hybrid",
    "hyperlink",
    "charset",
    "charsets",
    "chat",
    "china",
    "iban",
    "icmp",
    "icon",
    "icons",
    "icu",
    "idea",
    "ids",
    "ieee",
    "ignore",
    "illustration",
    "image",
    "imap",
    "imei",
    "import",
    "imsi",
    "inconsistent",
    "index",
    "india",
    "indigo",
    "individual",
    "info",
    "information",
    "infrastructure",
    "inline",
    "inno",
    "innodb",
    "innosetup",
    "input",
    "ins",
    "insert",
    "insights",
    "instagram",
    "install",
    "installation",
    "int",
    "integer",
    "interface",
    "interlingua",
    "international",
    "internet",
    "intl",
    "intro",
    "introduction",
    "ion",
    "ios",
    "ipsum",
    "iptables",
    "ipv",
    "irc",
    "irda",
    "irix",
    "isbn",
    "isdn",
    "ismn",
    "iso",
    "isrc",
    "issn",
    "item",
    "items",
    "jabber",
    "jami",
    "java",
    "javascript",
    "jdbc",
    "join",
    "joins",
    "joomla",
    "jpeg",
    "jpg",
    "json",
    "kappa",
    "karaoke",
    "kbps",
    "kernel",
    "keycloak",
    "kgz",
    "kib",
    "kill",
    "knoppix",
    "kong",
    "korfbal",
    "label",
    "labels",
    "land",
    "latex",
    "latin",
    "latitude",
    "layout",
    "ldif",
    "leap",
    "legal",
    "level",
    "liberapay",
    "libgammu",
    "libre",
    "lime",
    "linestring",
    "linguist",
    "link",
    "links",
    "linux",
    "list",
    "litecoin",
    "lithium",
    "local",
    "locales",
    "lock",
    "log",
    "logcheck",
    "login",
    "logo",
    "logos",
    "longitude",
    "lord",
    "lorem",
    "ltr",
    "lua",
    "lzma",
    "lzo",
    "mac",
    "macos",
    "magazine",
    "magazines",
    "magenta",
    "mah",
    "mail",
    "mailbird",
    "mailbox",
    "mailboxes",
    "maildir",
    "mailing",
    "majordomo",
    "mako",
    "manager",
    "mandrake",
    "mandriva",
    "manual",
    "mapillary",
    "markdown",
    "master",
    "material",
    "matrix",
    "max",
    "maximum",
    "media",
    "mediawiki",
    "medium",
    "menu",
    "mercurial",
    "merge",
    "merchandise",
    "mesh",
    "message",
    "messageformat",
    "messages",
    "meta",
    "metadata",
    "metal",
    "metre",
    "metres",
    "mhz",
    "mib",
    "micropayment",
    "micropayments",
    "microsoft",
    "migration",
    "mile",
    "min",
    "minimum",
    "mint",
    "minus",
    "minute",
    "minutes",
    "mm²",
    "mode",
    "model",
    "module",
    "modules",
    "monero",
    "monitor",
    "mono",
    "monument",
    "motel",
    "motif",
    "mouse",
    "mozilla",
    "mph",
    "multiplayer",
    "musical",
    "musicbottle",
    "mysql",
    "name",
    "namecoin",
    "namecoins",
    "navigation",
    "navy",
    "net",
    "netfilter",
    "network",
    "neutral",
    "next",
    "nimh",
    "node",
    "none",
    "normal",
    "note",
    "notes",
    "notification",
    "notifications",
    "notify",
    "null",
    "num",
    "number",
    "numeric",
    "oauth",
    "obex",
    "office",
    "offline",
    "offset",
    "ogg",
    "online",
    "ons",  # codespell:ignore ons
    "opac",
    "open",
    "openai",
    "opendocument",
    "openmaps",
    "openpgp",
    "openstreet",
    "opensuse",
    "openvpn",
    "opera",
    "operator",
    "option",
    "options",
    "orange",
    "orientation",
    "original",
    "osm",
    "osmand",
    "osx",
    "output",
    "overhead",
    "package",
    "page",
    "pager",
    "pages",
    "panel",
    "parameter",
    "parameters",
    "park",
    "parking",
    "parser",
    "partition",
    "partitions",
    "party",
    "password",
    "patreon",
    "pause",
    "paypal",
    "pdf",
    "pdu",
    "per",
    "percent",
    "performance",
    "perfume",
    "personal",
    "php",
    "phpmyadmin",
    "pib",
    "picasa",
    "pin",
    "ping",
    "pirate",
    "pirates",
    "pixel",
    "pixels",
    "placement",
    "plan",
    "platform",
    "playlist",
    "plugin",
    "plugins",
    "plural",
    "plurals",
    "plus",
    "png",
    "podcast",
    "podcasts",
    "point",
    "points",
    "polygon",
    "polymer",
    "pool",
    "port",
    "portable",
    "portrait",
    "position",
    "post",
    "postgresql",
    "posts",
    "postscript",
    "ppp",
    "pppoe",
    "pre",
    "prefix",
    "premium",
    "prince",
    "privacy",
    "private",
    "procedure",
    "procedures",
    "process",
    "processing",
    "profiling",
    "program",
    "progress",
    "project",
    "promotion",
    "properties",
    "property",
    "protocol",
    "provider",
    "proxy",
    "public",
    "pull",
    "push",
    "python",
    "query",
    "question",
    "questions",
    "radar",
    "radio",
    "radius",
    "rate",
    "react",
    "reality",
    "realm",
    "rebase",
    "recaptcha",
    "recent",
    "reddit",
    "redhat",
    "redis",
    "reg",
    "regexp",
    "region",
    "relation",
    "relations",
    "release",
    "render",
    "replication",
    "report",
    "reports",
    "repository",
    "reset",
    "resource",
    "responsive",
    "restart",
    "restaurant",
    "restaurants",
    "return",
    "rich",
    "richtext",
    "rijndael",
    "roadmap",
    "robot",
    "role",
    "roles",
    "root",
    "route",
    "routine",
    "routines",
    "rss",
    "rst",
    "rtl",
    "ruby",
    "salt",
    "sauna",
    "saver",
    "scalable",
    "scenario",
    "score",
    "screen",
    "screensaver",
    "screenshot",
    "script",
    "scripting",
    "scripts",
    "scroll",
    "scrum",
    "sdk",
    "sector",
    "seed",
    "selinux",
    "send",
    "sergeant",
    "serie",  # codespell:ignore serie
    "series",
    "server",
    "servers",
    "service",
    "set",
    "setup",
    "shell",
    "shift",
    "signature",
    "sim",
    "singular",
    "sip",
    "site",
    "skype",
    "slack",
    "slash",
    "slide",
    "slideshow",
    "slot",
    "slots",
    "slug",
    "sms",
    "smsc",
    "smsd",
    "smtp",
    "snapshot",
    "snapshots",
    "snmp",
    "social",
    "socket",
    "software",
    "solaris",
    "source",
    "spam",
    "spatial",
    "spline",
    "spoiler",
    "sponsor",
    "sponsors",
    "sport",
    "sprint",
    "sql",
    "sqlite",
    "squid",
    "ssh",
    "ssl",
    "sso",
    "stack",
    "standard",
    "start",
    "starttls",
    "stat",
    "statement",
    "stats",
    "status",
    "stereo",
    "stop",
    "string",
    "strings",
    "structure",
    "studio",
    "stun",
    "style",
    "submit",
    "subquery",
    "substring",
    "suggestion",
    "suggestions",
    "sum",
    "sunos",
    "supermarket",
    "support",
    "surfing",
    "suse",
    "svg",
    "swap",
    "symbol",
    "synaptic",
    "syndication",
    "syntax",
    "system",
    "tab",
    "table",
    "tables",
    "tabs",
    "tada",
    "tag",
    "tags",
    "taiwan",
    "taxi",
    "taxon",
    "tbx",
    "tcp",
    "team",
    "teams",
    "technologies",
    "technology",
    "telegram",
    "telnet",
    "template",
    "tent",
    "term",
    "termbase",
    "terminal",
    "test",
    "text",
    "texy",
    "theme",
    "theora",
    "thread",
    "threads",
    "thriller",
    "thunderbird",
    "tib",
    "timer",
    "tip",
    "tls",
    "todo",
    "todos",
    "token",
    "top",
    "tor",
    "total",
    "tour",
    "trailer",
    "transfer",
    "transformation",
    "transformations",
    "transistor",
    "transport",
    "tray",
    "trigger",
    "triggers",
    "true",
    "turbo",
    "tutorial",
    "twiki",
    "twitter",
    "type",
    "ubuntu",
    "udp",
    "uefi",
    "ukolovnik",
    "unicode",
    "unique",
    "unit",
    "universal",
    "unix",
    "update",
    "upload",
    "upnp",
    "url",
    "user",
    "utf",
    "variable",
    "variables",
    "vcalendar",
    "vcard",
    "vector",
    "vendor",
    "version",
    "versions",
    "vertical",
    "video",
    "view",
    "views",
    "vim",
    "vip",
    "virus",
    "visa",
    "vkontakte",
    "volume",
    "vorbis",
    "vote",
    "votes",
    "vue",
    "wammu",
    "web",
    "webdav",
    "webextension",
    "webgl",
    "webhook",
    "weblate",
    "webmail",
    "website",
    "widget",
    "widgets",
    "wifi",
    "wiki",
    "wikipedia",
    "wildcard",
    "windowed",
    "windows",
    "word",
    "www",
    "xen",
    "xhtml",
    "xkeys",
    "xliff",
    "xml",
    "yahoo",
    "yaml",
    "yandex",
    "yard",
    "youtube",
    "zcash",
    "zen",
    "zero",
    "zeta",
    "zip",
    "zombie",
    "zone",
    "zoo",
    "zoom",
    "zstd",
    # Currencies
    "btc",
    "eur",
    "usd",
    # Months are same in some languages
    "january",
    "february",
    "march",
    "april",
    "may",
    "june",
    "july",
    "august",
    "september",
    "october",
    "november",
    "december",
    "jan",
    "feb",
    "mar",
    "apr",
    "jun",
    "jul",
    "aug",
    "sep",
    "oct",
    "nov",
    "dec",
    # Week names shotrcuts
    "mon",
    "tue",
    "wed",
    "thu",
    "fri",
    "sat",
    "sun",
    # Roman numbers
    "iii",
    # Architectures
    "alpha",
    "amd",
    "arm",
    "aarch",
    "hppa",
    "powerpc",
    "sparc",
    # whole alphabet
    string.ascii_lowercase,
}
