# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.5 on 2023-09-18 08:16

import django.db.models.deletion
from django.db import migrations, models

from weblate.checks.models import CHECKS


class Migration(migrations.Migration):
    replaces = [
        ("checks", "0001_squashed_0003_auto_20191212_1441"),
        ("checks", "0004_auto_20200516_1821"),
        ("checks", "0005_alter_check_options"),
        ("checks", "0006_auto_20210923_0807"),
        ("checks", "0007_alter_check_unit"),
    ]

    initial = True

    dependencies = [
        ("lang", "0001_squashed_weblate_5"),
        ("trans", "0001_squashed_weblate_5"),
    ]

    operations = [
        migrations.CreateModel(
            name="Check",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        choices=CHECKS.get_choices(),
                        max_length=50,
                    ),
                ),
                ("dismissed", models.BooleanField(db_index=True, default=False)),
                (
                    "unit",
                    models.ForeignKey(
                        db_index=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="trans.unit",
                    ),
                ),
            ],
            options={
                "unique_together": {("unit", "name")},
                "verbose_name": "Quality check",
                "verbose_name_plural": "Quality checks",
            },
        ),
    ]
