# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.5 on 2023-09-18 08:07

from django.db import migrations, models

CATEGORY_MT = 2


def migrate_machinery(apps, schema_editor) -> None:
    Setting = apps.get_model("configuration", "Setting")

    for name in ("weblate", "weblate-translation-memory"):
        Setting.objects.create(category=CATEGORY_MT, name=name, value={})


class Migration(migrations.Migration):
    replaces = [
        ("configuration", "0001_initial"),
        ("configuration", "0002_alter_setting_options"),
        ("configuration", "0003_alter_setting_category"),
        ("configuration", "0004_machinery"),
    ]

    initial = True

    dependencies = [
        ("trans", "0001_squashed_weblate_5"),
    ]

    operations = [
        migrations.CreateModel(
            name="Setting",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "category",
                    models.IntegerField(choices=[(1, "UI"), (2, "MT")], db_index=True),
                ),
                ("name", models.CharField(max_length=100)),
                ("value", models.JSONField()),
            ],
            options={
                "unique_together": {("category", "name")},
                "verbose_name": "Setting",
                "verbose_name_plural": "Settings",
            },
        ),
        migrations.RunPython(migrate_machinery, migrations.RunPython.noop),
    ]
