# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.9 on 2024-01-26 14:17

from django.db import migrations


def drop_index(apps, schema_editor) -> None:
    """Drop indexes created manually in Weblate 5.3 and older."""
    vendor = schema_editor.connection.vendor
    if vendor == "postgresql":
        schema_editor.execute("DROP INDEX IF EXISTS memory_source_index")
        schema_editor.execute("DROP INDEX IF EXISTS memory_target_index")
        schema_editor.execute("DROP INDEX IF EXISTS memory_origin_index")


class Migration(migrations.Migration):
    dependencies = [
        ("memory", "0002_memory_memory_md5_index"),
    ]

    operations = [
        migrations.RunPython(
            code=drop_index,
            reverse_code=migrations.RunPython.noop,
            elidable=True,
        ),
    ]
