# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.0.6 on 2024-07-24 06:27
from django.db import migrations


def insert_public_project_data_in_latest_metric(apps, schema_editor) -> None:
    access_public = 0
    access_protected = 1
    scope_global = 0

    Metric = apps.get_model("metrics", "Metric")
    Project = apps.get_model("trans", "Project")
    public_projects_count = Project.objects.filter(
        access_control__in={access_public, access_protected}
    ).count()

    # tests will not have Metric objects
    if (
        latest_global_metric := Metric.objects.filter(scope=scope_global)
        .order_by("date")
        .last()
    ) and len(latest_global_metric.data) == 27:
        latest_global_metric.data.append(public_projects_count)
        latest_global_metric.save()


class Migration(migrations.Migration):
    dependencies = [
        ("metrics", "0001_squashed_weblate_5"),
    ]

    operations = [
        migrations.RunPython(
            insert_public_project_data_in_latest_metric,
            migrations.RunPython.noop,
            elidable=True,
        ),
    ]
