# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.5 on 2023-09-18 08:33

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import weblate.screenshots.fields


class Migration(migrations.Migration):
    replaces = [
        ("screenshots", "0001_squashed_0006_remove_screenshot_sources"),
        ("screenshots", "0002_screenshot_translation"),
        ("screenshots", "0003_fill_translation"),
        ("screenshots", "0004_auto_20201002_1423"),
        ("screenshots", "0005_alter_screenshot_options"),
        ("screenshots", "0006_screenshot_repository_filename"),
        ("screenshots", "0007_alter_screenshot_image"),
    ]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("trans", "0001_squashed_weblate_5"),
    ]

    operations = [
        migrations.CreateModel(
            name="Screenshot",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=200, verbose_name="Screenshot name"),
                ),
                (
                    "image",
                    weblate.screenshots.fields.ScreenshotField(
                        help_text="Upload image up to 2000x2000 pixels.",
                        upload_to="screenshots/",
                        verbose_name="Image",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "units",
                    models.ManyToManyField(
                        blank=True, related_name="screenshots", to="trans.unit"
                    ),
                ),
                (
                    "translation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="trans.translation",
                    ),
                ),
                (
                    "repository_filename",
                    models.CharField(
                        blank=True,
                        help_text="Scan for screenshot file change on repository update.",
                        max_length=200,
                        verbose_name="Repository path to screenshot",
                    ),
                ),
            ],
            options={
                "verbose_name": "Screenshot",
                "verbose_name_plural": "Screenshots",
            },
        ),
    ]
