# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.0.3 on 2024-03-27 12:56

from django.conf import settings
from django.db import migrations, models

import weblate.utils.render
import weblate.utils.validators


class Migration(migrations.Migration):
    dependencies = [
        ("trans", "0013_alter_category_options_category_category_slug_unique_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="component",
            name="repoweb",
            field=models.URLField(
                blank=True,
                help_text="Link to repository browser, use {{branch}} for branch, {{filename}} and {{line}} as filename and line placeholders. You might want to strip leading directory by using {{filename|parentdir}}.",
                validators=[
                    weblate.utils.validators.WeblateURLValidator(),
                    weblate.utils.render.validate_repoweb,
                ],
                verbose_name="Repository browser",
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="web",
            field=models.URLField(
                help_text="Main website of translated project.",
                validators=[
                    weblate.utils.validators.WeblateURLValidator(),
                    weblate.utils.validators.validate_project_web,
                ],
                verbose_name="Project website",
                blank=not settings.WEBSITE_REQUIRED,
            ),
        ),
    ]
