# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.0.6 on 2024-05-21 06:12

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("trans", "0016_alter_component_repoweb"),
    ]

    operations = [
        migrations.AlterField(
            model_name="announcement",
            name="category",
            field=models.CharField(
                choices=[
                    ("info", "Info (light blue)"),
                    ("warning", "Warning (yellow)"),
                    ("danger", "Danger (red)"),
                    ("success", "Success (green)"),
                ],
                default="info",
                help_text="Severity defines color used for the message.",
                max_length=25,
                verbose_name="Severity",
            ),
        ),
        migrations.RenameField(
            model_name="announcement",
            old_name="category",
            new_name="severity",
        ),
        migrations.AddField(
            model_name="change",
            name="category",
            field=models.ForeignKey(
                db_index=False,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="trans.category",
            ),
        ),
        migrations.AddField(
            model_name="announcement",
            name="category",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="trans.category",
                verbose_name="Category",
            ),
        ),
    ]
