# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later
# Generated by Django 5.2.1 on 2025-06-17 17:42

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("trans", "0038_alter_change_action"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="PendingUnitChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("target", models.TextField(blank=True, default="")),
                ("explanation", models.TextField(blank=True, default="")),
                ("source_unit_explanation", models.TextField(blank=True, default="")),
                (
                    "state",
                    models.IntegerField(
                        choices=[
                            (0, "Empty"),
                            (10, "Needs editing"),
                            (20, "Translated"),
                            (30, "Approved"),
                            (100, "Read-only"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                ("add_unit", models.BooleanField(default=False)),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "unit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="pending_changes",
                        to="trans.unit",
                    ),
                ),
            ],
            options={
                "verbose_name": "pending change",
                "verbose_name_plural": "pending changes",
            },
        ),
    ]
