# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

"""
License data definitions.

This is an automatically generated file, see scripts/generate-license-data.py
"""

LICENSES = (
    (
        "3D-Slicer-1.0",
        "3D Slicer License v1.0",
        "https://spdx.org/licenses/3D-Slicer-1.0.html",
        False,
    ),
    (
        "Glide",
        "3dfx Glide License",
        "https://spdx.org/licenses/Glide.html",
        False,
    ),
    (
        "Abstyles",
        "Abstyles License",
        "https://spdx.org/licenses/Abstyles.html",
        False,
    ),
    (
        "AFL-1.1",
        "Academic Free License v1.1",
        "https://spdx.org/licenses/AFL-1.1.html",
        True,
    ),
    (
        "AFL-1.2",
        "Academic Free License v1.2",
        "https://spdx.org/licenses/AFL-1.2.html",
        True,
    ),
    (
        "AFL-2.0",
        "Academic Free License v2.0",
        "https://spdx.org/licenses/AFL-2.0.html",
        True,
    ),
    (
        "AFL-2.1",
        "Academic Free License v2.1",
        "https://spdx.org/licenses/AFL-2.1.html",
        True,
    ),
    (
        "AFL-3.0",
        "Academic Free License v3.0",
        "https://spdx.org/licenses/AFL-3.0.html",
        True,
    ),
    (
        "AMPAS",
        "Academy of Motion Picture Arts and Sciences BSD",
        "https://spdx.org/licenses/AMPAS.html",
        False,
    ),
    (
        "AdaCore-doc",
        "AdaCore Doc License",
        "https://spdx.org/licenses/AdaCore-doc.html",
        False,
    ),
    (
        "APL-1.0",
        "Adaptive Public License 1.0",
        "https://spdx.org/licenses/APL-1.0.html",
        True,
    ),
    (
        "Adobe-Display-PostScript",
        "Adobe Display PostScript License",
        "https://spdx.org/licenses/Adobe-Display-PostScript.html",
        False,
    ),
    (
        "Adobe-Glyph",
        "Adobe Glyph List License",
        "https://spdx.org/licenses/Adobe-Glyph.html",
        False,
    ),
    (
        "APAFML",
        "Adobe Postscript AFM License",
        "https://spdx.org/licenses/APAFML.html",
        False,
    ),
    (
        "Adobe-2006",
        "Adobe Systems Incorporated Source Code License Agreement",
        "https://spdx.org/licenses/Adobe-2006.html",
        False,
    ),
    (
        "Adobe-Utopia",
        "Adobe Utopia Font License",
        "https://spdx.org/licenses/Adobe-Utopia.html",
        False,
    ),
    (
        "Advanced-Cryptics-Dictionary",
        "Advanced Cryptics Dictionary License",
        "https://spdx.org/licenses/Advanced-Cryptics-Dictionary.html",
        False,
    ),
    (
        "AGPL-1.0-only",
        "Affero General Public License v1.0 only",
        "https://spdx.org/licenses/AGPL-1.0-only.html",
        False,
    ),
    (
        "AGPL-1.0-or-later",
        "Affero General Public License v1.0 or later",
        "https://spdx.org/licenses/AGPL-1.0-or-later.html",
        False,
    ),
    (
        "Afmparse",
        "Afmparse License",
        "https://spdx.org/licenses/Afmparse.html",
        False,
    ),
    (
        "Aladdin",
        "Aladdin Free Public License",
        "https://spdx.org/licenses/Aladdin.html",
        False,
    ),
    (
        "ADSL",
        "Amazon Digital Services License",
        "https://spdx.org/licenses/ADSL.html",
        False,
    ),
    (
        "AMD-newlib",
        "AMD newlib License",
        "https://spdx.org/licenses/AMD-newlib.html",
        False,
    ),
    (
        "AMDPLPA",
        "AMD's plpa_map.c License",
        "https://spdx.org/licenses/AMDPLPA.html",
        False,
    ),
    (
        "AML-glslang",
        "AML glslang variant License",
        "https://spdx.org/licenses/AML-glslang.html",
        False,
    ),
    (
        "ANTLR-PD",
        "ANTLR Software Rights Notice",
        "https://spdx.org/licenses/ANTLR-PD.html",
        False,
    ),
    (
        "ANTLR-PD-fallback",
        "ANTLR Software Rights Notice with license fallback",
        "https://spdx.org/licenses/ANTLR-PD-fallback.html",
        False,
    ),
    (
        "any-OSI",
        "Any OSI License",
        "https://spdx.org/licenses/any-OSI.html",
        False,
    ),
    (
        "any-OSI-perl-modules",
        "Any OSI License - Perl Modules",
        "https://spdx.org/licenses/any-OSI-perl-modules.html",
        False,
    ),
    (
        "Apache-1.0",
        "Apache License 1.0",
        "https://spdx.org/licenses/Apache-1.0.html",
        True,
    ),
    (
        "Apache-1.1",
        "Apache License 1.1",
        "https://spdx.org/licenses/Apache-1.1.html",
        True,
    ),
    (
        "Apache-2.0",
        "Apache License 2.0",
        "https://spdx.org/licenses/Apache-2.0.html",
        True,
    ),
    (
        "App-s2p",
        "App::s2p License",
        "https://spdx.org/licenses/App-s2p.html",
        False,
    ),
    (
        "AML",
        "Apple MIT License",
        "https://spdx.org/licenses/AML.html",
        False,
    ),
    (
        "APSL-1.0",
        "Apple Public Source License 1.0",
        "https://spdx.org/licenses/APSL-1.0.html",
        True,
    ),
    (
        "APSL-1.1",
        "Apple Public Source License 1.1",
        "https://spdx.org/licenses/APSL-1.1.html",
        True,
    ),
    (
        "APSL-1.2",
        "Apple Public Source License 1.2",
        "https://spdx.org/licenses/APSL-1.2.html",
        True,
    ),
    (
        "APSL-2.0",
        "Apple Public Source License 2.0",
        "https://spdx.org/licenses/APSL-2.0.html",
        True,
    ),
    (
        "Arphic-1999",
        "Arphic Public License",
        "https://spdx.org/licenses/Arphic-1999.html",
        False,
    ),
    (
        "Artistic-1.0",
        "Artistic License 1.0",
        "https://spdx.org/licenses/Artistic-1.0.html",
        True,
    ),
    (
        "Artistic-dist",
        "Artistic License 1.0 (dist)",
        "https://spdx.org/licenses/Artistic-dist.html",
        False,
    ),
    (
        "Artistic-1.0-Perl",
        "Artistic License 1.0 (Perl)",
        "https://spdx.org/licenses/Artistic-1.0-Perl.html",
        True,
    ),
    (
        "Artistic-1.0-cl8",
        "Artistic License 1.0 w/clause 8",
        "https://spdx.org/licenses/Artistic-1.0-cl8.html",
        True,
    ),
    (
        "Artistic-2.0",
        "Artistic License 2.0",
        "https://spdx.org/licenses/Artistic-2.0.html",
        True,
    ),
    (
        "Aspell-RU",
        "Aspell Russian License",
        "https://spdx.org/licenses/Aspell-RU.html",
        False,
    ),
    (
        "ASWF-Digital-Assets-1.1",
        "ASWF Digital Assets License 1.1",
        "https://spdx.org/licenses/ASWF-Digital-Assets-1.1.html",
        False,
    ),
    (
        "ASWF-Digital-Assets-1.0",
        "ASWF Digital Assets License version 1.0",
        "https://spdx.org/licenses/ASWF-Digital-Assets-1.0.html",
        False,
    ),
    (
        "AAL",
        "Attribution Assurance License",
        "https://spdx.org/licenses/AAL.html",
        True,
    ),
    (
        "Baekmuk",
        "Baekmuk License",
        "https://spdx.org/licenses/Baekmuk.html",
        False,
    ),
    (
        "Bahyph",
        "Bahyph License",
        "https://spdx.org/licenses/Bahyph.html",
        False,
    ),
    (
        "Barr",
        "Barr License",
        "https://spdx.org/licenses/Barr.html",
        False,
    ),
    (
        "bcrypt-Solar-Designer",
        "bcrypt Solar Designer License",
        "https://spdx.org/licenses/bcrypt-Solar-Designer.html",
        False,
    ),
    (
        "Beerware",
        "Beerware License",
        "https://spdx.org/licenses/Beerware.html",
        True,
    ),
    (
        "Bitstream-Charter",
        "Bitstream Charter Font License",
        "https://spdx.org/licenses/Bitstream-Charter.html",
        False,
    ),
    (
        "Bitstream-Vera",
        "Bitstream Vera Font License",
        "https://spdx.org/licenses/Bitstream-Vera.html",
        False,
    ),
    (
        "BitTorrent-1.0",
        "BitTorrent Open Source License v1.0",
        "https://spdx.org/licenses/BitTorrent-1.0.html",
        False,
    ),
    (
        "BitTorrent-1.1",
        "BitTorrent Open Source License v1.1",
        "https://spdx.org/licenses/BitTorrent-1.1.html",
        True,
    ),
    (
        "BlueOak-1.0.0",
        "Blue Oak Model License 1.0.0",
        "https://spdx.org/licenses/BlueOak-1.0.0.html",
        True,
    ),
    (
        "Boehm-GC",
        "Boehm-Demers-Weiser GC License",
        "https://spdx.org/licenses/Boehm-GC.html",
        False,
    ),
    (
        "Boehm-GC-without-fee",
        "Boehm-Demers-Weiser GC License (without fee)",
        "https://spdx.org/licenses/Boehm-GC-without-fee.html",
        False,
    ),
    (
        "BSL-1.0",
        "Boost Software License 1.0",
        "https://spdx.org/licenses/BSL-1.0.html",
        True,
    ),
    (
        "Borceux",
        "Borceux license",
        "https://spdx.org/licenses/Borceux.html",
        False,
    ),
    (
        "Brian-Gladman-2-Clause",
        "Brian Gladman 2-Clause License",
        "https://spdx.org/licenses/Brian-Gladman-2-Clause.html",
        False,
    ),
    (
        "Brian-Gladman-3-Clause",
        "Brian Gladman 3-Clause License",
        "https://spdx.org/licenses/Brian-Gladman-3-Clause.html",
        False,
    ),
    (
        "BSD-1-Clause",
        "BSD 1-Clause License",
        "https://spdx.org/licenses/BSD-1-Clause.html",
        True,
    ),
    (
        "BSD-2-Clause",
        'BSD 2-Clause "Simplified" License',
        "https://spdx.org/licenses/BSD-2-Clause.html",
        True,
    ),
    (
        "BSD-2-Clause-first-lines",
        "BSD 2-Clause - first lines requirement",
        "https://spdx.org/licenses/BSD-2-Clause-first-lines.html",
        False,
    ),
    (
        "BSD-2-Clause-Darwin",
        "BSD 2-Clause - Ian Darwin variant",
        "https://spdx.org/licenses/BSD-2-Clause-Darwin.html",
        False,
    ),
    (
        "BSD-2-Clause-pkgconf-disclaimer",
        "BSD 2-Clause pkgconf disclaimer variant",
        "https://spdx.org/licenses/BSD-2-Clause-pkgconf-disclaimer.html",
        False,
    ),
    (
        "BSD-2-Clause-Views",
        "BSD 2-Clause with views sentence",
        "https://spdx.org/licenses/BSD-2-Clause-Views.html",
        False,
    ),
    (
        "BSD-3-Clause",
        'BSD 3-Clause "New" or "Revised" License',
        "https://spdx.org/licenses/BSD-3-Clause.html",
        True,
    ),
    (
        "BSD-3-Clause-acpica",
        "BSD 3-Clause acpica variant",
        "https://spdx.org/licenses/BSD-3-Clause-acpica.html",
        False,
    ),
    (
        "BSD-3-Clause-Clear",
        "BSD 3-Clause Clear License",
        "https://spdx.org/licenses/BSD-3-Clause-Clear.html",
        True,
    ),
    (
        "BSD-3-Clause-flex",
        "BSD 3-Clause Flex variant",
        "https://spdx.org/licenses/BSD-3-Clause-flex.html",
        False,
    ),
    (
        "BSD-3-Clause-Modification",
        "BSD 3-Clause Modification",
        "https://spdx.org/licenses/BSD-3-Clause-Modification.html",
        False,
    ),
    (
        "BSD-3-Clause-No-Military-License",
        "BSD 3-Clause No Military License",
        "https://spdx.org/licenses/BSD-3-Clause-No-Military-License.html",
        False,
    ),
    (
        "BSD-3-Clause-No-Nuclear-License",
        "BSD 3-Clause No Nuclear License",
        "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License.html",
        False,
    ),
    (
        "BSD-3-Clause-No-Nuclear-License-2014",
        "BSD 3-Clause No Nuclear License 2014",
        "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License-2014.html",
        False,
    ),
    (
        "BSD-3-Clause-No-Nuclear-Warranty",
        "BSD 3-Clause No Nuclear Warranty",
        "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-Warranty.html",
        False,
    ),
    (
        "BSD-3-Clause-Open-MPI",
        "BSD 3-Clause Open MPI variant",
        "https://spdx.org/licenses/BSD-3-Clause-Open-MPI.html",
        True,
    ),
    (
        "BSD-3-Clause-Sun",
        "BSD 3-Clause Sun Microsystems",
        "https://spdx.org/licenses/BSD-3-Clause-Sun.html",
        False,
    ),
    (
        "BSD-3-Clause-Tso",
        "BSD 3-Clause Tso variant",
        "https://spdx.org/licenses/BSD-3-Clause-Tso.html",
        False,
    ),
    (
        "BSD-4-Clause-Shortened",
        "BSD 4 Clause Shortened",
        "https://spdx.org/licenses/BSD-4-Clause-Shortened.html",
        False,
    ),
    (
        "BSD-4-Clause",
        'BSD 4-Clause "Original" or "Old" License',
        "https://spdx.org/licenses/BSD-4-Clause.html",
        True,
    ),
    (
        "BSD-4.3RENO",
        "BSD 4.3 RENO License",
        "https://spdx.org/licenses/BSD-4.3RENO.html",
        False,
    ),
    (
        "BSD-4.3TAHOE",
        "BSD 4.3 TAHOE License",
        "https://spdx.org/licenses/BSD-4.3TAHOE.html",
        False,
    ),
    (
        "BSD-Advertising-Acknowledgement",
        "BSD Advertising Acknowledgement License",
        "https://spdx.org/licenses/BSD-Advertising-Acknowledgement.html",
        False,
    ),
    (
        "BSD-Mark-Modifications",
        "BSD Mark Modifications License",
        "https://spdx.org/licenses/BSD-Mark-Modifications.html",
        False,
    ),
    (
        "BSD-Protection",
        "BSD Protection License",
        "https://spdx.org/licenses/BSD-Protection.html",
        False,
    ),
    (
        "BSD-Source-Code",
        "BSD Source Code Attribution",
        "https://spdx.org/licenses/BSD-Source-Code.html",
        False,
    ),
    (
        "BSD-Source-beginning-file",
        "BSD Source Code Attribution - beginning of file variant",
        "https://spdx.org/licenses/BSD-Source-beginning-file.html",
        False,
    ),
    (
        "BSD-3-Clause-Attribution",
        "BSD with attribution",
        "https://spdx.org/licenses/BSD-3-Clause-Attribution.html",
        False,
    ),
    (
        "BSD-Attribution-HPND-disclaimer",
        "BSD with Attribution and HPND disclaimer",
        "https://spdx.org/licenses/BSD-Attribution-HPND-disclaimer.html",
        False,
    ),
    (
        "0BSD",
        "BSD Zero Clause License",
        "https://spdx.org/licenses/0BSD.html",
        True,
    ),
    (
        "BSD-2-Clause-Patent",
        "BSD-2-Clause Plus Patent License",
        "https://spdx.org/licenses/BSD-2-Clause-Patent.html",
        True,
    ),
    (
        "BSD-4-Clause-UC",
        "BSD-4-Clause (University of California-Specific)",
        "https://spdx.org/licenses/BSD-4-Clause-UC.html",
        False,
    ),
    (
        "BSD-Inferno-Nettverk",
        "BSD-Inferno-Nettverk",
        "https://spdx.org/licenses/BSD-Inferno-Nettverk.html",
        False,
    ),
    (
        "BUSL-1.1",
        "Business Source License 1.1",
        "https://spdx.org/licenses/BUSL-1.1.html",
        False,
    ),
    (
        "bzip2-1.0.6",
        "bzip2 and libbzip2 License v1.0.6",
        "https://spdx.org/licenses/bzip2-1.0.6.html",
        False,
    ),
    (
        "Caldera",
        "Caldera License",
        "https://spdx.org/licenses/Caldera.html",
        False,
    ),
    (
        "Caldera-no-preamble",
        "Caldera License (without preamble)",
        "https://spdx.org/licenses/Caldera-no-preamble.html",
        False,
    ),
    (
        "Catharon",
        "Catharon License",
        "https://spdx.org/licenses/Catharon.html",
        False,
    ),
    (
        "CECILL-1.0",
        "CeCILL Free Software License Agreement v1.0",
        "https://spdx.org/licenses/CECILL-1.0.html",
        False,
    ),
    (
        "CECILL-1.1",
        "CeCILL Free Software License Agreement v1.1",
        "https://spdx.org/licenses/CECILL-1.1.html",
        False,
    ),
    (
        "CECILL-2.0",
        "CeCILL Free Software License Agreement v2.0",
        "https://spdx.org/licenses/CECILL-2.0.html",
        True,
    ),
    (
        "CECILL-2.1",
        "CeCILL Free Software License Agreement v2.1",
        "https://spdx.org/licenses/CECILL-2.1.html",
        True,
    ),
    (
        "CECILL-B",
        "CeCILL-B Free Software License Agreement",
        "https://spdx.org/licenses/CECILL-B.html",
        True,
    ),
    (
        "CECILL-C",
        "CeCILL-C Free Software License Agreement",
        "https://spdx.org/licenses/CECILL-C.html",
        True,
    ),
    (
        "CERN-OHL-1.1",
        "CERN Open Hardware Licence v1.1",
        "https://spdx.org/licenses/CERN-OHL-1.1.html",
        False,
    ),
    (
        "CERN-OHL-1.2",
        "CERN Open Hardware Licence v1.2",
        "https://spdx.org/licenses/CERN-OHL-1.2.html",
        False,
    ),
    (
        "CERN-OHL-P-2.0",
        "CERN Open Hardware Licence Version 2 - Permissive",
        "https://spdx.org/licenses/CERN-OHL-P-2.0.html",
        True,
    ),
    (
        "CERN-OHL-S-2.0",
        "CERN Open Hardware Licence Version 2 - Strongly Reciprocal",
        "https://spdx.org/licenses/CERN-OHL-S-2.0.html",
        True,
    ),
    (
        "CERN-OHL-W-2.0",
        "CERN Open Hardware Licence Version 2 - Weakly Reciprocal",
        "https://spdx.org/licenses/CERN-OHL-W-2.0.html",
        True,
    ),
    (
        "CFITSIO",
        "CFITSIO License",
        "https://spdx.org/licenses/CFITSIO.html",
        False,
    ),
    (
        "check-cvs",
        "check-cvs License",
        "https://spdx.org/licenses/check-cvs.html",
        False,
    ),
    (
        "checkmk",
        "Checkmk License",
        "https://spdx.org/licenses/checkmk.html",
        False,
    ),
    (
        "ClArtistic",
        "Clarified Artistic License",
        "https://spdx.org/licenses/ClArtistic.html",
        True,
    ),
    (
        "Clips",
        "Clips License",
        "https://spdx.org/licenses/Clips.html",
        False,
    ),
    (
        "CMU-Mach-nodoc",
        "CMU    Mach - no notices-in-documentation variant",
        "https://spdx.org/licenses/CMU-Mach-nodoc.html",
        False,
    ),
    (
        "MIT-CMU",
        "CMU License",
        "https://spdx.org/licenses/MIT-CMU.html",
        False,
    ),
    (
        "CMU-Mach",
        "CMU Mach License",
        "https://spdx.org/licenses/CMU-Mach.html",
        False,
    ),
    (
        "CNRI-Jython",
        "CNRI Jython License",
        "https://spdx.org/licenses/CNRI-Jython.html",
        False,
    ),
    (
        "CNRI-Python",
        "CNRI Python License",
        "https://spdx.org/licenses/CNRI-Python.html",
        True,
    ),
    (
        "CNRI-Python-GPL-Compatible",
        "CNRI Python Open Source GPL Compatible License Agreement",
        "https://spdx.org/licenses/CNRI-Python-GPL-Compatible.html",
        False,
    ),
    (
        "CPOL-1.02",
        "Code Project Open License 1.02",
        "https://spdx.org/licenses/CPOL-1.02.html",
        False,
    ),
    (
        "CDDL-1.0",
        "Common Development and Distribution License 1.0",
        "https://spdx.org/licenses/CDDL-1.0.html",
        True,
    ),
    (
        "CDDL-1.1",
        "Common Development and Distribution License 1.1",
        "https://spdx.org/licenses/CDDL-1.1.html",
        False,
    ),
    (
        "CDL-1.0",
        "Common Documentation License 1.0",
        "https://spdx.org/licenses/CDL-1.0.html",
        False,
    ),
    (
        "LOOP",
        "Common Lisp LOOP License",
        "https://spdx.org/licenses/LOOP.html",
        False,
    ),
    (
        "CPAL-1.0",
        "Common Public Attribution License 1.0",
        "https://spdx.org/licenses/CPAL-1.0.html",
        True,
    ),
    (
        "CPL-1.0",
        "Common Public License 1.0",
        "https://spdx.org/licenses/CPL-1.0.html",
        True,
    ),
    (
        "cve-tou",
        "Common Vulnerability Enumeration ToU License",
        "https://spdx.org/licenses/cve-tou.html",
        False,
    ),
    (
        "CDLA-Permissive-1.0",
        "Community Data License Agreement Permissive 1.0",
        "https://spdx.org/licenses/CDLA-Permissive-1.0.html",
        False,
    ),
    (
        "CDLA-Permissive-2.0",
        "Community Data License Agreement Permissive 2.0",
        "https://spdx.org/licenses/CDLA-Permissive-2.0.html",
        False,
    ),
    (
        "CDLA-Sharing-1.0",
        "Community Data License Agreement Sharing 1.0",
        "https://spdx.org/licenses/CDLA-Sharing-1.0.html",
        False,
    ),
    (
        "Community-Spec-1.0",
        "Community Specification License 1.0",
        "https://spdx.org/licenses/Community-Spec-1.0.html",
        False,
    ),
    (
        "C-UDA-1.0",
        "Computational Use of Data Agreement v1.0",
        "https://spdx.org/licenses/C-UDA-1.0.html",
        False,
    ),
    (
        "CATOSL-1.1",
        "Computer Associates Trusted Open Source License 1.1",
        "https://spdx.org/licenses/CATOSL-1.1.html",
        True,
    ),
    (
        "Condor-1.1",
        "Condor Public License v1.1",
        "https://spdx.org/licenses/Condor-1.1.html",
        True,
    ),
    (
        "COIL-1.0",
        "Copyfree Open Innovation License",
        "https://spdx.org/licenses/COIL-1.0.html",
        False,
    ),
    (
        "copyleft-next-0.3.0",
        "copyleft-next 0.3.0",
        "https://spdx.org/licenses/copyleft-next-0.3.0.html",
        False,
    ),
    (
        "copyleft-next-0.3.1",
        "copyleft-next 0.3.1",
        "https://spdx.org/licenses/copyleft-next-0.3.1.html",
        False,
    ),
    (
        "Cornell-Lossless-JPEG",
        "Cornell Lossless JPEG License",
        "https://spdx.org/licenses/Cornell-Lossless-JPEG.html",
        False,
    ),
    (
        "CC-PDM-1.0",
        "Creative    Commons Public Domain Mark 1.0 Universal",
        "https://spdx.org/licenses/CC-PDM-1.0.html",
        False,
    ),
    (
        "CC-BY-1.0",
        "Creative Commons Attribution 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-1.0.html",
        False,
    ),
    (
        "CC-BY-2.0",
        "Creative Commons Attribution 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-2.0.html",
        False,
    ),
    (
        "CC-BY-2.5-AU",
        "Creative Commons Attribution 2.5 Australia",
        "https://spdx.org/licenses/CC-BY-2.5-AU.html",
        False,
    ),
    (
        "CC-BY-2.5",
        "Creative Commons Attribution 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-2.5.html",
        False,
    ),
    (
        "CC-BY-3.0-AU",
        "Creative Commons Attribution 3.0 Australia",
        "https://spdx.org/licenses/CC-BY-3.0-AU.html",
        False,
    ),
    (
        "CC-BY-3.0-AT",
        "Creative Commons Attribution 3.0 Austria",
        "https://spdx.org/licenses/CC-BY-3.0-AT.html",
        False,
    ),
    (
        "CC-BY-3.0-DE",
        "Creative Commons Attribution 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-3.0-IGO",
        "Creative Commons Attribution 3.0 IGO",
        "https://spdx.org/licenses/CC-BY-3.0-IGO.html",
        False,
    ),
    (
        "CC-BY-3.0-NL",
        "Creative Commons Attribution 3.0 Netherlands",
        "https://spdx.org/licenses/CC-BY-3.0-NL.html",
        False,
    ),
    (
        "CC-BY-3.0-US",
        "Creative Commons Attribution 3.0 United States",
        "https://spdx.org/licenses/CC-BY-3.0-US.html",
        False,
    ),
    (
        "CC-BY-3.0",
        "Creative Commons Attribution 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-3.0.html",
        True,
    ),
    (
        "CC-BY-4.0",
        "Creative Commons Attribution 4.0 International",
        "https://spdx.org/licenses/CC-BY-4.0.html",
        True,
    ),
    (
        "CC-BY-ND-1.0",
        "Creative Commons Attribution No Derivatives 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-ND-1.0.html",
        False,
    ),
    (
        "CC-BY-ND-2.0",
        "Creative Commons Attribution No Derivatives 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-ND-2.0.html",
        False,
    ),
    (
        "CC-BY-ND-2.5",
        "Creative Commons Attribution No Derivatives 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-ND-2.5.html",
        False,
    ),
    (
        "CC-BY-ND-3.0-DE",
        "Creative Commons Attribution No Derivatives 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-ND-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-ND-3.0",
        "Creative Commons Attribution No Derivatives 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-ND-3.0.html",
        False,
    ),
    (
        "CC-BY-ND-4.0",
        "Creative Commons Attribution No Derivatives 4.0 International",
        "https://spdx.org/licenses/CC-BY-ND-4.0.html",
        False,
    ),
    (
        "CC-BY-NC-1.0",
        "Creative Commons Attribution Non Commercial 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-1.0.html",
        False,
    ),
    (
        "CC-BY-NC-2.0",
        "Creative Commons Attribution Non Commercial 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-2.0.html",
        False,
    ),
    (
        "CC-BY-NC-2.5",
        "Creative Commons Attribution Non Commercial 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-NC-2.5.html",
        False,
    ),
    (
        "CC-BY-NC-3.0-DE",
        "Creative Commons Attribution Non Commercial 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-NC-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-NC-3.0",
        "Creative Commons Attribution Non Commercial 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-NC-3.0.html",
        False,
    ),
    (
        "CC-BY-NC-4.0",
        "Creative Commons Attribution Non Commercial 4.0 International",
        "https://spdx.org/licenses/CC-BY-NC-4.0.html",
        False,
    ),
    (
        "CC-BY-NC-ND-1.0",
        "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-ND-1.0.html",
        False,
    ),
    (
        "CC-BY-NC-ND-2.0",
        "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-ND-2.0.html",
        False,
    ),
    (
        "CC-BY-NC-ND-2.5",
        "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-NC-ND-2.5.html",
        False,
    ),
    (
        "CC-BY-NC-ND-3.0-DE",
        "Creative Commons Attribution Non Commercial No Derivatives 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-NC-ND-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-NC-ND-3.0-IGO",
        "Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO",
        "https://spdx.org/licenses/CC-BY-NC-ND-3.0-IGO.html",
        False,
    ),
    (
        "CC-BY-NC-ND-3.0",
        "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-NC-ND-3.0.html",
        False,
    ),
    (
        "CC-BY-NC-ND-4.0",
        "Creative Commons Attribution Non Commercial No Derivatives 4.0 International",
        "https://spdx.org/licenses/CC-BY-NC-ND-4.0.html",
        False,
    ),
    (
        "CC-BY-NC-SA-1.0",
        "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-SA-1.0.html",
        False,
    ),
    (
        "CC-BY-NC-SA-2.0-UK",
        "Creative Commons Attribution Non Commercial Share Alike 2.0 England and Wales",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.0-UK.html",
        False,
    ),
    (
        "CC-BY-NC-SA-2.0",
        "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.0.html",
        False,
    ),
    (
        "CC-BY-NC-SA-2.0-DE",
        "Creative Commons Attribution Non Commercial Share Alike 2.0 Germany",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.0-DE.html",
        False,
    ),
    (
        "CC-BY-NC-SA-2.5",
        "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.5.html",
        False,
    ),
    (
        "CC-BY-NC-SA-3.0-DE",
        "Creative Commons Attribution Non Commercial Share Alike 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-NC-SA-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-NC-SA-3.0-IGO",
        "Creative Commons Attribution Non Commercial Share Alike 3.0 IGO",
        "https://spdx.org/licenses/CC-BY-NC-SA-3.0-IGO.html",
        False,
    ),
    (
        "CC-BY-NC-SA-3.0",
        "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-NC-SA-3.0.html",
        False,
    ),
    (
        "CC-BY-NC-SA-4.0",
        "Creative Commons Attribution Non Commercial Share Alike 4.0 International",
        "https://spdx.org/licenses/CC-BY-NC-SA-4.0.html",
        False,
    ),
    (
        "CC-BY-SA-1.0",
        "Creative Commons Attribution Share Alike 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-SA-1.0.html",
        False,
    ),
    (
        "CC-BY-SA-2.0-UK",
        "Creative Commons Attribution Share Alike 2.0 England and Wales",
        "https://spdx.org/licenses/CC-BY-SA-2.0-UK.html",
        False,
    ),
    (
        "CC-BY-SA-2.0",
        "Creative Commons Attribution Share Alike 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-SA-2.0.html",
        False,
    ),
    (
        "CC-BY-SA-2.1-JP",
        "Creative Commons Attribution Share Alike 2.1 Japan",
        "https://spdx.org/licenses/CC-BY-SA-2.1-JP.html",
        False,
    ),
    (
        "CC-BY-SA-2.5",
        "Creative Commons Attribution Share Alike 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-SA-2.5.html",
        False,
    ),
    (
        "CC-BY-SA-3.0-AT",
        "Creative Commons Attribution Share Alike 3.0 Austria",
        "https://spdx.org/licenses/CC-BY-SA-3.0-AT.html",
        False,
    ),
    (
        "CC-BY-SA-3.0-DE",
        "Creative Commons Attribution Share Alike 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-SA-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-SA-3.0",
        "Creative Commons Attribution Share Alike 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-SA-3.0.html",
        True,
    ),
    (
        "CC-BY-SA-4.0",
        "Creative Commons Attribution Share Alike 4.0 International",
        "https://spdx.org/licenses/CC-BY-SA-4.0.html",
        True,
    ),
    (
        "CC-BY-NC-SA-2.0-FR",
        "Creative Commons Attribution-NonCommercial-ShareAlike 2.0 France",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.0-FR.html",
        False,
    ),
    (
        "CC-BY-SA-3.0-IGO",
        "Creative Commons Attribution-ShareAlike 3.0 IGO",
        "https://spdx.org/licenses/CC-BY-SA-3.0-IGO.html",
        False,
    ),
    (
        "CC-PDDC",
        "Creative Commons Public Domain Dedication and Certification",
        "https://spdx.org/licenses/CC-PDDC.html",
        False,
    ),
    (
        "CC-SA-1.0",
        "Creative Commons Share Alike 1.0 Generic",
        "https://spdx.org/licenses/CC-SA-1.0.html",
        False,
    ),
    (
        "CC0-1.0",
        "Creative Commons Zero v1.0 Universal",
        "https://spdx.org/licenses/CC0-1.0.html",
        True,
    ),
    (
        "Cronyx",
        "Cronyx License",
        "https://spdx.org/licenses/Cronyx.html",
        False,
    ),
    (
        "Crossword",
        "Crossword License",
        "https://spdx.org/licenses/Crossword.html",
        False,
    ),
    (
        "CAL-1.0",
        "Cryptographic Autonomy License 1.0",
        "https://spdx.org/licenses/CAL-1.0.html",
        True,
    ),
    (
        "CAL-1.0-Combined-Work-Exception",
        "Cryptographic Autonomy License 1.0 (Combined Work Exception)",
        "https://spdx.org/licenses/CAL-1.0-Combined-Work-Exception.html",
        True,
    ),
    (
        "CryptoSwift",
        "CryptoSwift License",
        "https://spdx.org/licenses/CryptoSwift.html",
        False,
    ),
    (
        "CrystalStacker",
        "CrystalStacker License",
        "https://spdx.org/licenses/CrystalStacker.html",
        False,
    ),
    (
        "CUA-OPL-1.0",
        "CUA Office Public License v1.0",
        "https://spdx.org/licenses/CUA-OPL-1.0.html",
        True,
    ),
    (
        "Cube",
        "Cube License",
        "https://spdx.org/licenses/Cube.html",
        False,
    ),
    (
        "curl",
        "curl License",
        "https://spdx.org/licenses/curl.html",
        False,
    ),
    (
        "DL-DE-BY-2.0",
        "Data licence Germany – attribution – version 2.0",
        "https://spdx.org/licenses/DL-DE-BY-2.0.html",
        False,
    ),
    (
        "DL-DE-ZERO-2.0",
        "Data licence Germany – zero – version 2.0",
        "https://spdx.org/licenses/DL-DE-ZERO-2.0.html",
        False,
    ),
    (
        "dtoa",
        "David M. Gay dtoa License",
        "https://spdx.org/licenses/dtoa.html",
        False,
    ),
    (
        "DEC-3-Clause",
        "DEC 3-Clause License",
        "https://spdx.org/licenses/DEC-3-Clause.html",
        False,
    ),
    (
        "DRL-1.0",
        "Detection Rule License 1.0",
        "https://spdx.org/licenses/DRL-1.0.html",
        False,
    ),
    (
        "DRL-1.1",
        "Detection Rule License 1.1",
        "https://spdx.org/licenses/DRL-1.1.html",
        False,
    ),
    (
        "D-FSL-1.0",
        "Deutsche Freie Software Lizenz",
        "https://spdx.org/licenses/D-FSL-1.0.html",
        False,
    ),
    (
        "diffmark",
        "diffmark license",
        "https://spdx.org/licenses/diffmark.html",
        False,
    ),
    (
        "WTFNMFPL",
        "Do What The F*ck You Want To But It's Not My Fault Public License",
        "https://spdx.org/licenses/WTFNMFPL.html",
        False,
    ),
    (
        "WTFPL",
        "Do What The F*ck You Want To Public License",
        "https://spdx.org/licenses/WTFPL.html",
        True,
    ),
    (
        "DOC",
        "DOC License",
        "https://spdx.org/licenses/DOC.html",
        False,
    ),
    (
        "DocBook-DTD",
        "DocBook DTD License",
        "https://spdx.org/licenses/DocBook-DTD.html",
        False,
    ),
    (
        "DocBook-Schema",
        "DocBook Schema License",
        "https://spdx.org/licenses/DocBook-Schema.html",
        False,
    ),
    (
        "DocBook-Stylesheet",
        "DocBook Stylesheet License",
        "https://spdx.org/licenses/DocBook-Stylesheet.html",
        False,
    ),
    (
        "DocBook-XML",
        "DocBook XML License",
        "https://spdx.org/licenses/DocBook-XML.html",
        False,
    ),
    (
        "Dotseqn",
        "Dotseqn License",
        "https://spdx.org/licenses/Dotseqn.html",
        False,
    ),
    (
        "DSDP",
        "DSDP License",
        "https://spdx.org/licenses/DSDP.html",
        False,
    ),
    (
        "dvipdfm",
        "dvipdfm License",
        "https://spdx.org/licenses/dvipdfm.html",
        False,
    ),
    (
        "EPL-1.0",
        "Eclipse Public License 1.0",
        "https://spdx.org/licenses/EPL-1.0.html",
        True,
    ),
    (
        "EPL-2.0",
        "Eclipse Public License 2.0",
        "https://spdx.org/licenses/EPL-2.0.html",
        True,
    ),
    (
        "ECL-1.0",
        "Educational Community License v1.0",
        "https://spdx.org/licenses/ECL-1.0.html",
        True,
    ),
    (
        "ECL-2.0",
        "Educational Community License v2.0",
        "https://spdx.org/licenses/ECL-2.0.html",
        True,
    ),
    (
        "eGenix",
        "eGenix.com Public License 1.1.0",
        "https://spdx.org/licenses/eGenix.html",
        False,
    ),
    (
        "EFL-1.0",
        "Eiffel Forum License v1.0",
        "https://spdx.org/licenses/EFL-1.0.html",
        True,
    ),
    (
        "EFL-2.0",
        "Eiffel Forum License v2.0",
        "https://spdx.org/licenses/EFL-2.0.html",
        True,
    ),
    (
        "Elastic-2.0",
        "Elastic License 2.0",
        "https://spdx.org/licenses/Elastic-2.0.html",
        False,
    ),
    (
        "MIT-advertising",
        "Enlightenment License (e16)",
        "https://spdx.org/licenses/MIT-advertising.html",
        False,
    ),
    (
        "MIT-enna",
        "enna License",
        "https://spdx.org/licenses/MIT-enna.html",
        False,
    ),
    (
        "Entessa",
        "Entessa Public License v1.0",
        "https://spdx.org/licenses/Entessa.html",
        True,
    ),
    (
        "EPICS",
        "EPICS Open License",
        "https://spdx.org/licenses/EPICS.html",
        False,
    ),
    (
        "ErlPL-1.1",
        "Erlang Public License v1.1",
        "https://spdx.org/licenses/ErlPL-1.1.html",
        False,
    ),
    (
        "etalab-2.0",
        "Etalab Open License 2.0",
        "https://spdx.org/licenses/etalab-2.0.html",
        False,
    ),
    (
        "EUDatagrid",
        "EU DataGrid Software License",
        "https://spdx.org/licenses/EUDatagrid.html",
        True,
    ),
    (
        "ESA-PL-strong-copyleft-2.4",
        "European Space Agency Public License (ESA-PL) - V2.4 - Strong Copyleft (Type 1)",
        "https://spdx.org/licenses/ESA-PL-strong-copyleft-2.4.html",
        False,
    ),
    (
        "ESA-PL-permissive-2.4",
        "European Space Agency Public License – v2.4 – Permissive (Type 3)",
        "https://spdx.org/licenses/ESA-PL-permissive-2.4.html",
        False,
    ),
    (
        "ESA-PL-weak-copyleft-2.4",
        "European Space Agency Public License – v2.4 – Weak Copyleft (Type 2)",
        "https://spdx.org/licenses/ESA-PL-weak-copyleft-2.4.html",
        False,
    ),
    (
        "EUPL-1.0",
        "European Union Public License 1.0",
        "https://spdx.org/licenses/EUPL-1.0.html",
        False,
    ),
    (
        "EUPL-1.1",
        "European Union Public License 1.1",
        "https://spdx.org/licenses/EUPL-1.1.html",
        True,
    ),
    (
        "EUPL-1.2",
        "European Union Public License 1.2",
        "https://spdx.org/licenses/EUPL-1.2.html",
        True,
    ),
    (
        "Eurosym",
        "Eurosym License",
        "https://spdx.org/licenses/Eurosym.html",
        False,
    ),
    (
        "Fair",
        "Fair License",
        "https://spdx.org/licenses/Fair.html",
        True,
    ),
    (
        "MIT-feh",
        "feh License",
        "https://spdx.org/licenses/MIT-feh.html",
        False,
    ),
    (
        "Ferguson-Twofish",
        "Ferguson Twofish License",
        "https://spdx.org/licenses/Ferguson-Twofish.html",
        False,
    ),
    (
        "Frameworx-1.0",
        "Frameworx Open License 1.0",
        "https://spdx.org/licenses/Frameworx-1.0.html",
        True,
    ),
    (
        "FDK-AAC",
        "Fraunhofer FDK AAC Codec Library",
        "https://spdx.org/licenses/FDK-AAC.html",
        False,
    ),
    (
        "FreeBSD-DOC",
        "FreeBSD Documentation License",
        "https://spdx.org/licenses/FreeBSD-DOC.html",
        False,
    ),
    (
        "FreeImage",
        "FreeImage Public License v1.0",
        "https://spdx.org/licenses/FreeImage.html",
        False,
    ),
    (
        "FTL",
        "Freetype Project License",
        "https://spdx.org/licenses/FTL.html",
        True,
    ),
    (
        "FSFAP",
        "FSF All Permissive License",
        "https://spdx.org/licenses/FSFAP.html",
        True,
    ),
    (
        "FSFAP-no-warranty-disclaimer",
        "FSF All Permissive License (without Warranty)",
        "https://spdx.org/licenses/FSFAP-no-warranty-disclaimer.html",
        False,
    ),
    (
        "FSFUL",
        "FSF Unlimited License",
        "https://spdx.org/licenses/FSFUL.html",
        False,
    ),
    (
        "FSFULLRSD",
        "FSF Unlimited License (with License Retention and Short Disclaimer)",
        "https://spdx.org/licenses/FSFULLRSD.html",
        False,
    ),
    (
        "FSFULLRWD",
        "FSF Unlimited License (With License Retention and Warranty Disclaimer)",
        "https://spdx.org/licenses/FSFULLRWD.html",
        False,
    ),
    (
        "FSFULLR",
        "FSF Unlimited License (with License Retention)",
        "https://spdx.org/licenses/FSFULLR.html",
        False,
    ),
    (
        "FSL-1.1-ALv2",
        "Functional Source License, Version 1.1, ALv2 Future License",
        "https://spdx.org/licenses/FSL-1.1-ALv2.html",
        False,
    ),
    (
        "FSL-1.1-MIT",
        "Functional Source License, Version 1.1, MIT Future License",
        "https://spdx.org/licenses/FSL-1.1-MIT.html",
        False,
    ),
    (
        "Furuseth",
        "Furuseth License",
        "https://spdx.org/licenses/Furuseth.html",
        False,
    ),
    (
        "FBM",
        "Fuzzy Bitmap License",
        "https://spdx.org/licenses/FBM.html",
        False,
    ),
    (
        "fwlw",
        "fwlw License",
        "https://spdx.org/licenses/fwlw.html",
        False,
    ),
    (
        "Game-Programming-Gems",
        "Game Programming Gems License",
        "https://spdx.org/licenses/Game-Programming-Gems.html",
        False,
    ),
    (
        "GD",
        "GD License",
        "https://spdx.org/licenses/GD.html",
        False,
    ),
    (
        "generic-xts",
        "Generic XTS License",
        "https://spdx.org/licenses/generic-xts.html",
        False,
    ),
    (
        "Giftware",
        "Giftware License",
        "https://spdx.org/licenses/Giftware.html",
        False,
    ),
    (
        "GL2PS",
        "GL2PS License",
        "https://spdx.org/licenses/GL2PS.html",
        False,
    ),
    (
        "Glulxe",
        "Glulxe License",
        "https://spdx.org/licenses/Glulxe.html",
        False,
    ),
    (
        "GCR-docs",
        "Gnome GCR Documentation License",
        "https://spdx.org/licenses/GCR-docs.html",
        False,
    ),
    (
        "AGPL-3.0-only",
        "GNU Affero General Public License v3.0 only",
        "https://spdx.org/licenses/AGPL-3.0-only.html",
        True,
    ),
    (
        "AGPL-3.0-or-later",
        "GNU Affero General Public License v3.0 or later",
        "https://spdx.org/licenses/AGPL-3.0-or-later.html",
        True,
    ),
    (
        "GFDL-1.1-only",
        "GNU Free Documentation License v1.1 only",
        "https://spdx.org/licenses/GFDL-1.1-only.html",
        True,
    ),
    (
        "GFDL-1.1-invariants-only",
        "GNU Free Documentation License v1.1 only - invariants",
        "https://spdx.org/licenses/GFDL-1.1-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.1-no-invariants-only",
        "GNU Free Documentation License v1.1 only - no invariants",
        "https://spdx.org/licenses/GFDL-1.1-no-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.1-or-later",
        "GNU Free Documentation License v1.1 or later",
        "https://spdx.org/licenses/GFDL-1.1-or-later.html",
        True,
    ),
    (
        "GFDL-1.1-invariants-or-later",
        "GNU Free Documentation License v1.1 or later - invariants",
        "https://spdx.org/licenses/GFDL-1.1-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.1-no-invariants-or-later",
        "GNU Free Documentation License v1.1 or later - no invariants",
        "https://spdx.org/licenses/GFDL-1.1-no-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.2-only",
        "GNU Free Documentation License v1.2 only",
        "https://spdx.org/licenses/GFDL-1.2-only.html",
        True,
    ),
    (
        "GFDL-1.2-invariants-only",
        "GNU Free Documentation License v1.2 only - invariants",
        "https://spdx.org/licenses/GFDL-1.2-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.2-no-invariants-only",
        "GNU Free Documentation License v1.2 only - no invariants",
        "https://spdx.org/licenses/GFDL-1.2-no-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.2-or-later",
        "GNU Free Documentation License v1.2 or later",
        "https://spdx.org/licenses/GFDL-1.2-or-later.html",
        True,
    ),
    (
        "GFDL-1.2-invariants-or-later",
        "GNU Free Documentation License v1.2 or later - invariants",
        "https://spdx.org/licenses/GFDL-1.2-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.2-no-invariants-or-later",
        "GNU Free Documentation License v1.2 or later - no invariants",
        "https://spdx.org/licenses/GFDL-1.2-no-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.3-only",
        "GNU Free Documentation License v1.3 only",
        "https://spdx.org/licenses/GFDL-1.3-only.html",
        True,
    ),
    (
        "GFDL-1.3-invariants-only",
        "GNU Free Documentation License v1.3 only - invariants",
        "https://spdx.org/licenses/GFDL-1.3-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.3-no-invariants-only",
        "GNU Free Documentation License v1.3 only - no invariants",
        "https://spdx.org/licenses/GFDL-1.3-no-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.3-or-later",
        "GNU Free Documentation License v1.3 or later",
        "https://spdx.org/licenses/GFDL-1.3-or-later.html",
        True,
    ),
    (
        "GFDL-1.3-invariants-or-later",
        "GNU Free Documentation License v1.3 or later - invariants",
        "https://spdx.org/licenses/GFDL-1.3-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.3-no-invariants-or-later",
        "GNU Free Documentation License v1.3 or later - no invariants",
        "https://spdx.org/licenses/GFDL-1.3-no-invariants-or-later.html",
        False,
    ),
    (
        "GPL-1.0-only",
        "GNU General Public License v1.0 only",
        "https://spdx.org/licenses/GPL-1.0-only.html",
        False,
    ),
    (
        "GPL-1.0-or-later",
        "GNU General Public License v1.0 or later",
        "https://spdx.org/licenses/GPL-1.0-or-later.html",
        False,
    ),
    (
        "GPL-2.0-only",
        "GNU General Public License v2.0 only",
        "https://spdx.org/licenses/GPL-2.0-only.html",
        True,
    ),
    (
        "GPL-2.0-or-later",
        "GNU General Public License v2.0 or later",
        "https://spdx.org/licenses/GPL-2.0-or-later.html",
        True,
    ),
    (
        "GPL-3.0-only",
        "GNU General Public License v3.0 only",
        "https://spdx.org/licenses/GPL-3.0-only.html",
        True,
    ),
    (
        "GPL-3.0-or-later",
        "GNU General Public License v3.0 or later",
        "https://spdx.org/licenses/GPL-3.0-or-later.html",
        True,
    ),
    (
        "LGPL-2.1-only",
        "GNU Lesser General Public License v2.1 only",
        "https://spdx.org/licenses/LGPL-2.1-only.html",
        True,
    ),
    (
        "LGPL-2.1-or-later",
        "GNU Lesser General Public License v2.1 or later",
        "https://spdx.org/licenses/LGPL-2.1-or-later.html",
        True,
    ),
    (
        "LGPL-3.0-only",
        "GNU Lesser General Public License v3.0 only",
        "https://spdx.org/licenses/LGPL-3.0-only.html",
        True,
    ),
    (
        "LGPL-3.0-or-later",
        "GNU Lesser General Public License v3.0 or later",
        "https://spdx.org/licenses/LGPL-3.0-or-later.html",
        True,
    ),
    (
        "LGPL-2.0-only",
        "GNU Library General Public License v2 only",
        "https://spdx.org/licenses/LGPL-2.0-only.html",
        True,
    ),
    (
        "LGPL-2.0-or-later",
        "GNU Library General Public License v2 or later",
        "https://spdx.org/licenses/LGPL-2.0-or-later.html",
        True,
    ),
    (
        "gnuplot",
        "gnuplot License",
        "https://spdx.org/licenses/gnuplot.html",
        True,
    ),
    (
        "GLWTPL",
        "Good Luck With That Public License",
        "https://spdx.org/licenses/GLWTPL.html",
        False,
    ),
    (
        "Graphics-Gems",
        "Graphics Gems License",
        "https://spdx.org/licenses/Graphics-Gems.html",
        False,
    ),
    (
        "gSOAP-1.3b",
        "gSOAP Public License v1.3b",
        "https://spdx.org/licenses/gSOAP-1.3b.html",
        False,
    ),
    (
        "gtkbook",
        "gtkbook License",
        "https://spdx.org/licenses/gtkbook.html",
        False,
    ),
    (
        "Gutmann",
        "Gutmann License",
        "https://spdx.org/licenses/Gutmann.html",
        False,
    ),
    (
        "HaskellReport",
        "Haskell Language Report License",
        "https://spdx.org/licenses/HaskellReport.html",
        False,
    ),
    (
        "HDF5",
        "HDF5 License",
        "https://spdx.org/licenses/HDF5.html",
        False,
    ),
    (
        "hdparm",
        "hdparm License",
        "https://spdx.org/licenses/hdparm.html",
        False,
    ),
    (
        "HP-1986",
        "Hewlett-Packard 1986 License",
        "https://spdx.org/licenses/HP-1986.html",
        False,
    ),
    (
        "HP-1989",
        "Hewlett-Packard 1989 License",
        "https://spdx.org/licenses/HP-1989.html",
        False,
    ),
    (
        "BSD-3-Clause-HP",
        "Hewlett-Packard BSD variant license",
        "https://spdx.org/licenses/BSD-3-Clause-HP.html",
        False,
    ),
    (
        "HIDAPI",
        "HIDAPI License",
        "https://spdx.org/licenses/HIDAPI.html",
        False,
    ),
    (
        "Hippocratic-2.1",
        "Hippocratic License 2.1",
        "https://spdx.org/licenses/Hippocratic-2.1.html",
        False,
    ),
    (
        "HPND",
        "Historical Permission Notice and Disclaimer",
        "https://spdx.org/licenses/HPND.html",
        True,
    ),
    (
        "HPND-INRIA-IMAG",
        "Historical Permission Notice and Disclaimer    - INRIA-IMAG variant",
        "https://spdx.org/licenses/HPND-INRIA-IMAG.html",
        False,
    ),
    (
        "HPND-DEC",
        "Historical Permission Notice and Disclaimer - DEC variant",
        "https://spdx.org/licenses/HPND-DEC.html",
        False,
    ),
    (
        "HPND-doc-sell",
        "Historical Permission Notice and Disclaimer - documentation sell variant",
        "https://spdx.org/licenses/HPND-doc-sell.html",
        False,
    ),
    (
        "HPND-doc",
        "Historical Permission Notice and Disclaimer - documentation variant",
        "https://spdx.org/licenses/HPND-doc.html",
        False,
    ),
    (
        "HPND-Fenneberg-Livingston",
        "Historical Permission Notice and Disclaimer - Fenneberg-Livingston variant",
        "https://spdx.org/licenses/HPND-Fenneberg-Livingston.html",
        False,
    ),
    (
        "HPND-Intel",
        "Historical Permission Notice and Disclaimer - Intel variant",
        "https://spdx.org/licenses/HPND-Intel.html",
        False,
    ),
    (
        "HPND-Kevlin-Henney",
        "Historical Permission Notice and Disclaimer - Kevlin Henney variant",
        "https://spdx.org/licenses/HPND-Kevlin-Henney.html",
        False,
    ),
    (
        "HPND-Markus-Kuhn",
        "Historical Permission Notice and Disclaimer - Markus Kuhn variant",
        "https://spdx.org/licenses/HPND-Markus-Kuhn.html",
        False,
    ),
    (
        "HPND-merchantability-variant",
        "Historical Permission Notice and Disclaimer - merchantability variant",
        "https://spdx.org/licenses/HPND-merchantability-variant.html",
        False,
    ),
    (
        "HPND-Netrek",
        "Historical Permission Notice and Disclaimer - Netrek variant",
        "https://spdx.org/licenses/HPND-Netrek.html",
        False,
    ),
    (
        "HPND-Pbmplus",
        "Historical Permission Notice and Disclaimer - Pbmplus variant",
        "https://spdx.org/licenses/HPND-Pbmplus.html",
        False,
    ),
    (
        "HPND-sell-regexpr",
        "Historical Permission Notice and Disclaimer - sell regexpr variant",
        "https://spdx.org/licenses/HPND-sell-regexpr.html",
        False,
    ),
    (
        "HPND-sell-variant",
        "Historical Permission Notice and Disclaimer - sell variant",
        "https://spdx.org/licenses/HPND-sell-variant.html",
        False,
    ),
    (
        "HPND-sell-MIT-disclaimer-xserver",
        "Historical Permission Notice and Disclaimer - sell xserver variant with MIT disclaimer",
        "https://spdx.org/licenses/HPND-sell-MIT-disclaimer-xserver.html",
        False,
    ),
    (
        "HPND-SMC",
        "Historical Permission Notice and Disclaimer - SMC variant",
        "https://spdx.org/licenses/HPND-SMC.html",
        False,
    ),
    (
        "HPND-UC",
        "Historical Permission Notice and Disclaimer - University of California variant",
        "https://spdx.org/licenses/HPND-UC.html",
        False,
    ),
    (
        "HPND-UC-export-US",
        "Historical Permission Notice and Disclaimer - University of California, US export warning",
        "https://spdx.org/licenses/HPND-UC-export-US.html",
        False,
    ),
    (
        "HPND-MIT-disclaimer",
        "Historical Permission Notice and Disclaimer with MIT disclaimer",
        "https://spdx.org/licenses/HPND-MIT-disclaimer.html",
        False,
    ),
    (
        "HPND-sell-variant-MIT-disclaimer",
        "HPND sell variant with MIT disclaimer",
        "https://spdx.org/licenses/HPND-sell-variant-MIT-disclaimer.html",
        False,
    ),
    (
        "HPND-sell-variant-MIT-disclaimer-rev",
        "HPND sell variant with MIT disclaimer - reverse",
        "https://spdx.org/licenses/HPND-sell-variant-MIT-disclaimer-rev.html",
        False,
    ),
    (
        "HPND-export2-US",
        "HPND with US Government export control and 2 disclaimers",
        "https://spdx.org/licenses/HPND-export2-US.html",
        False,
    ),
    (
        "HPND-export-US",
        "HPND with US Government export control warning",
        "https://spdx.org/licenses/HPND-export-US.html",
        False,
    ),
    (
        "HPND-export-US-acknowledgement",
        "HPND with US Government export control warning and acknowledgment",
        "https://spdx.org/licenses/HPND-export-US-acknowledgement.html",
        False,
    ),
    (
        "HPND-export-US-modify",
        "HPND with US Government export control warning and modification rqmt",
        "https://spdx.org/licenses/HPND-export-US-modify.html",
        False,
    ),
    (
        "HTMLTIDY",
        "HTML Tidy License",
        "https://spdx.org/licenses/HTMLTIDY.html",
        False,
    ),
    (
        "hyphen-bulgarian",
        "hyphen-bulgarian License",
        "https://spdx.org/licenses/hyphen-bulgarian.html",
        False,
    ),
    (
        "IBM-pibs",
        "IBM PowerPC Initialization and Boot Software",
        "https://spdx.org/licenses/IBM-pibs.html",
        False,
    ),
    (
        "IPL-1.0",
        "IBM Public License v1.0",
        "https://spdx.org/licenses/IPL-1.0.html",
        True,
    ),
    (
        "ICU",
        "ICU License",
        "https://spdx.org/licenses/ICU.html",
        True,
    ),
    (
        "IEC-Code-Components-EULA",
        "IEC    Code Components End-user licence agreement",
        "https://spdx.org/licenses/IEC-Code-Components-EULA.html",
        False,
    ),
    (
        "ImageMagick",
        "ImageMagick License",
        "https://spdx.org/licenses/ImageMagick.html",
        False,
    ),
    (
        "iMatix",
        "iMatix Standard Function Library Agreement",
        "https://spdx.org/licenses/iMatix.html",
        True,
    ),
    (
        "Imlib2",
        "Imlib2 License",
        "https://spdx.org/licenses/Imlib2.html",
        True,
    ),
    (
        "IJG",
        "Independent JPEG Group License",
        "https://spdx.org/licenses/IJG.html",
        True,
    ),
    (
        "IJG-short",
        "Independent JPEG Group License - short",
        "https://spdx.org/licenses/IJG-short.html",
        False,
    ),
    (
        "Info-ZIP",
        "Info-ZIP License",
        "https://spdx.org/licenses/Info-ZIP.html",
        False,
    ),
    (
        "Inner-Net-2.0",
        "Inner Net License v2.0",
        "https://spdx.org/licenses/Inner-Net-2.0.html",
        False,
    ),
    (
        "InnoSetup",
        "Inno Setup License",
        "https://spdx.org/licenses/InnoSetup.html",
        False,
    ),
    (
        "Intel-ACPI",
        "Intel ACPI Software License Agreement",
        "https://spdx.org/licenses/Intel-ACPI.html",
        False,
    ),
    (
        "Intel",
        "Intel Open Source License",
        "https://spdx.org/licenses/Intel.html",
        True,
    ),
    (
        "Interbase-1.0",
        "Interbase Public License v1.0",
        "https://spdx.org/licenses/Interbase-1.0.html",
        False,
    ),
    (
        "IPA",
        "IPA Font License",
        "https://spdx.org/licenses/IPA.html",
        True,
    ),
    (
        "ISC",
        "ISC License",
        "https://spdx.org/licenses/ISC.html",
        True,
    ),
    (
        "ISC-Veillard",
        "ISC Veillard variant",
        "https://spdx.org/licenses/ISC-Veillard.html",
        False,
    ),
    (
        "Jam",
        "Jam License",
        "https://spdx.org/licenses/Jam.html",
        True,
    ),
    (
        "JPNIC",
        "Japan Network Information Center License",
        "https://spdx.org/licenses/JPNIC.html",
        False,
    ),
    (
        "JasPer-2.0",
        "JasPer License",
        "https://spdx.org/licenses/JasPer-2.0.html",
        False,
    ),
    (
        "jove",
        "Jove License",
        "https://spdx.org/licenses/jove.html",
        False,
    ),
    (
        "JPL-image",
        "JPL Image Use Policy",
        "https://spdx.org/licenses/JPL-image.html",
        False,
    ),
    (
        "JSON",
        "JSON License",
        "https://spdx.org/licenses/JSON.html",
        False,
    ),
    (
        "Kastrup",
        "Kastrup License",
        "https://spdx.org/licenses/Kastrup.html",
        False,
    ),
    (
        "Kazlib",
        "Kazlib License",
        "https://spdx.org/licenses/Kazlib.html",
        False,
    ),
    (
        "Knuth-CTAN",
        "Knuth CTAN License",
        "https://spdx.org/licenses/Knuth-CTAN.html",
        False,
    ),
    (
        "LPPL-1.0",
        "LaTeX Project Public License v1.0",
        "https://spdx.org/licenses/LPPL-1.0.html",
        False,
    ),
    (
        "LPPL-1.1",
        "LaTeX Project Public License v1.1",
        "https://spdx.org/licenses/LPPL-1.1.html",
        False,
    ),
    (
        "LPPL-1.2",
        "LaTeX Project Public License v1.2",
        "https://spdx.org/licenses/LPPL-1.2.html",
        True,
    ),
    (
        "LPPL-1.3a",
        "LaTeX Project Public License v1.3a",
        "https://spdx.org/licenses/LPPL-1.3a.html",
        True,
    ),
    (
        "LPPL-1.3c",
        "LaTeX Project Public License v1.3c",
        "https://spdx.org/licenses/LPPL-1.3c.html",
        True,
    ),
    (
        "Latex2e",
        "Latex2e License",
        "https://spdx.org/licenses/Latex2e.html",
        False,
    ),
    (
        "Latex2e-translated-notice",
        "Latex2e with translated notice permission",
        "https://spdx.org/licenses/Latex2e-translated-notice.html",
        False,
    ),
    (
        "BSD-3-Clause-LBNL",
        "Lawrence Berkeley National Labs BSD variant license",
        "https://spdx.org/licenses/BSD-3-Clause-LBNL.html",
        True,
    ),
    (
        "Leptonica",
        "Leptonica License",
        "https://spdx.org/licenses/Leptonica.html",
        False,
    ),
    (
        "LGPLLR",
        "Lesser General Public License For Linguistic Resources",
        "https://spdx.org/licenses/LGPLLR.html",
        False,
    ),
    (
        "Libpng",
        "libpng License",
        "https://spdx.org/licenses/Libpng.html",
        False,
    ),
    (
        "libselinux-1.0",
        "libselinux public domain notice",
        "https://spdx.org/licenses/libselinux-1.0.html",
        False,
    ),
    (
        "libtiff",
        "libtiff License",
        "https://spdx.org/licenses/libtiff.html",
        False,
    ),
    (
        "libutil-David-Nugent",
        "libutil David Nugent License",
        "https://spdx.org/licenses/libutil-David-Nugent.html",
        False,
    ),
    (
        "LAL-1.2",
        "Licence Art Libre 1.2",
        "https://spdx.org/licenses/LAL-1.2.html",
        False,
    ),
    (
        "LAL-1.3",
        "Licence Art Libre 1.3",
        "https://spdx.org/licenses/LAL-1.3.html",
        False,
    ),
    (
        "LiLiQ-P-1.1",
        "Licence Libre du Québec – Permissive version 1.1",
        "https://spdx.org/licenses/LiLiQ-P-1.1.html",
        True,
    ),
    (
        "LiLiQ-Rplus-1.1",
        "Licence Libre du Québec – Réciprocité forte version 1.1",
        "https://spdx.org/licenses/LiLiQ-Rplus-1.1.html",
        True,
    ),
    (
        "LiLiQ-R-1.1",
        "Licence Libre du Québec – Réciprocité version 1.1",
        "https://spdx.org/licenses/LiLiQ-R-1.1.html",
        True,
    ),
    (
        "Linux-OpenIB",
        "Linux Kernel Variant of OpenIB.org license",
        "https://spdx.org/licenses/Linux-OpenIB.html",
        False,
    ),
    (
        "Linux-man-pages-1-para",
        "Linux man-pages - 1 paragraph",
        "https://spdx.org/licenses/Linux-man-pages-1-para.html",
        False,
    ),
    (
        "Linux-man-pages-copyleft",
        "Linux man-pages Copyleft",
        "https://spdx.org/licenses/Linux-man-pages-copyleft.html",
        False,
    ),
    (
        "Linux-man-pages-copyleft-2-para",
        "Linux man-pages Copyleft - 2 paragraphs",
        "https://spdx.org/licenses/Linux-man-pages-copyleft-2-para.html",
        False,
    ),
    (
        "Linux-man-pages-copyleft-var",
        "Linux man-pages Copyleft Variant",
        "https://spdx.org/licenses/Linux-man-pages-copyleft-var.html",
        False,
    ),
    (
        "LPD-document",
        "LPD Documentation License",
        "https://spdx.org/licenses/LPD-document.html",
        False,
    ),
    (
        "lsof",
        "lsof License",
        "https://spdx.org/licenses/lsof.html",
        False,
    ),
    (
        "LPL-1.02",
        "Lucent Public License v1.02",
        "https://spdx.org/licenses/LPL-1.02.html",
        True,
    ),
    (
        "LPL-1.0",
        "Lucent Public License Version 1.0",
        "https://spdx.org/licenses/LPL-1.0.html",
        True,
    ),
    (
        "Lucida-Bitmap-Fonts",
        "Lucida Bitmap Fonts License",
        "https://spdx.org/licenses/Lucida-Bitmap-Fonts.html",
        False,
    ),
    (
        "LZMA-SDK-9.11-to-9.20",
        "LZMA SDK License (versions 9.11 to 9.20)",
        "https://spdx.org/licenses/LZMA-SDK-9.11-to-9.20.html",
        False,
    ),
    (
        "LZMA-SDK-9.22",
        "LZMA SDK License (versions 9.22 and beyond)",
        "https://spdx.org/licenses/LZMA-SDK-9.22.html",
        False,
    ),
    (
        "Mackerras-3-Clause-acknowledgment",
        "Mackerras 3-Clause - acknowledgment variant",
        "https://spdx.org/licenses/Mackerras-3-Clause-acknowledgment.html",
        False,
    ),
    (
        "Mackerras-3-Clause",
        "Mackerras 3-Clause License",
        "https://spdx.org/licenses/Mackerras-3-Clause.html",
        False,
    ),
    (
        "magaz",
        "magaz License",
        "https://spdx.org/licenses/magaz.html",
        False,
    ),
    (
        "mailprio",
        "mailprio License",
        "https://spdx.org/licenses/mailprio.html",
        False,
    ),
    (
        "MakeIndex",
        "MakeIndex License",
        "https://spdx.org/licenses/MakeIndex.html",
        False,
    ),
    (
        "man2html",
        "man2html License",
        "https://spdx.org/licenses/man2html.html",
        False,
    ),
    (
        "Martin-Birgmeier",
        "Martin Birgmeier License",
        "https://spdx.org/licenses/Martin-Birgmeier.html",
        False,
    ),
    (
        "MTLL",
        "Matrix Template Library License",
        "https://spdx.org/licenses/MTLL.html",
        False,
    ),
    (
        "McPhee-slideshow",
        "McPhee Slideshow License",
        "https://spdx.org/licenses/McPhee-slideshow.html",
        False,
    ),
    (
        "metamail",
        "metamail License",
        "https://spdx.org/licenses/metamail.html",
        False,
    ),
    (
        "UMich-Merit",
        "Michigan/Merit Networks License",
        "https://spdx.org/licenses/UMich-Merit.html",
        False,
    ),
    (
        "MS-LPL",
        "Microsoft Limited Public License",
        "https://spdx.org/licenses/MS-LPL.html",
        False,
    ),
    (
        "MS-PL",
        "Microsoft Public License",
        "https://spdx.org/licenses/MS-PL.html",
        True,
    ),
    (
        "MS-RL",
        "Microsoft Reciprocal License",
        "https://spdx.org/licenses/MS-RL.html",
        True,
    ),
    (
        "Minpack",
        "Minpack License",
        "https://spdx.org/licenses/Minpack.html",
        False,
    ),
    (
        "MIPS",
        "MIPS License",
        "https://spdx.org/licenses/MIPS.html",
        False,
    ),
    (
        "MITNFA",
        "MIT +no-false-attribs license",
        "https://spdx.org/licenses/MITNFA.html",
        False,
    ),
    (
        "MIT-Click",
        "MIT Click License",
        "https://spdx.org/licenses/MIT-Click.html",
        False,
    ),
    (
        "MIT-Festival",
        "MIT Festival Variant",
        "https://spdx.org/licenses/MIT-Festival.html",
        False,
    ),
    (
        "MIT-Khronos-old",
        "MIT Khronos - old variant",
        "https://spdx.org/licenses/MIT-Khronos-old.html",
        False,
    ),
    (
        "MIT",
        "MIT License",
        "https://spdx.org/licenses/MIT.html",
        True,
    ),
    (
        "MIT-Modern-Variant",
        "MIT License Modern Variant",
        "https://spdx.org/licenses/MIT-Modern-Variant.html",
        True,
    ),
    (
        "MIT-0",
        "MIT No Attribution",
        "https://spdx.org/licenses/MIT-0.html",
        True,
    ),
    (
        "MIT-open-group",
        "MIT Open Group variant",
        "https://spdx.org/licenses/MIT-open-group.html",
        False,
    ),
    (
        "MIT-testregex",
        "MIT testregex Variant",
        "https://spdx.org/licenses/MIT-testregex.html",
        False,
    ),
    (
        "MIT-Wu",
        "MIT Tom Wu Variant",
        "https://spdx.org/licenses/MIT-Wu.html",
        False,
    ),
    (
        "MMIXware",
        "MMIXware License",
        "https://spdx.org/licenses/MMIXware.html",
        False,
    ),
    (
        "Motosoto",
        "Motosoto License",
        "https://spdx.org/licenses/Motosoto.html",
        True,
    ),
    (
        "MPL-1.0",
        "Mozilla Public License 1.0",
        "https://spdx.org/licenses/MPL-1.0.html",
        True,
    ),
    (
        "MPL-1.1",
        "Mozilla Public License 1.1",
        "https://spdx.org/licenses/MPL-1.1.html",
        True,
    ),
    (
        "MPL-2.0",
        "Mozilla Public License 2.0",
        "https://spdx.org/licenses/MPL-2.0.html",
        True,
    ),
    (
        "MPL-2.0-no-copyleft-exception",
        "Mozilla Public License 2.0 (no copyleft exception)",
        "https://spdx.org/licenses/MPL-2.0-no-copyleft-exception.html",
        True,
    ),
    (
        "MPEG-SSG",
        "MPEG Software Simulation",
        "https://spdx.org/licenses/MPEG-SSG.html",
        False,
    ),
    (
        "mpi-permissive",
        "mpi Permissive License",
        "https://spdx.org/licenses/mpi-permissive.html",
        False,
    ),
    (
        "mpich2",
        "mpich2 License",
        "https://spdx.org/licenses/mpich2.html",
        False,
    ),
    (
        "mplus",
        "mplus Font License",
        "https://spdx.org/licenses/mplus.html",
        False,
    ),
    (
        "MulanPSL-1.0",
        "Mulan Permissive Software License, Version 1",
        "https://spdx.org/licenses/MulanPSL-1.0.html",
        False,
    ),
    (
        "MulanPSL-2.0",
        "Mulan Permissive Software License, Version 2",
        "https://spdx.org/licenses/MulanPSL-2.0.html",
        True,
    ),
    (
        "Multics",
        "Multics License",
        "https://spdx.org/licenses/Multics.html",
        True,
    ),
    (
        "Mup",
        "Mup License",
        "https://spdx.org/licenses/Mup.html",
        False,
    ),
    (
        "NAIST-2003",
        "Nara Institute of Science and Technology License (2003)",
        "https://spdx.org/licenses/NAIST-2003.html",
        False,
    ),
    (
        "NASA-1.3",
        "NASA Open Source Agreement 1.3",
        "https://spdx.org/licenses/NASA-1.3.html",
        True,
    ),
    (
        "Naumen",
        "Naumen Public License",
        "https://spdx.org/licenses/Naumen.html",
        True,
    ),
    (
        "NCBI-PD",
        "NCBI Public Domain Notice",
        "https://spdx.org/licenses/NCBI-PD.html",
        False,
    ),
    (
        "NCL",
        "NCL Source Code License",
        "https://spdx.org/licenses/NCL.html",
        False,
    ),
    (
        "NBPL-1.0",
        "Net Boolean Public License v1",
        "https://spdx.org/licenses/NBPL-1.0.html",
        False,
    ),
    (
        "NetCDF",
        "NetCDF license",
        "https://spdx.org/licenses/NetCDF.html",
        False,
    ),
    (
        "NGPL",
        "Nethack General Public License",
        "https://spdx.org/licenses/NGPL.html",
        True,
    ),
    (
        "NOSL",
        "Netizen Open Source License",
        "https://spdx.org/licenses/NOSL.html",
        True,
    ),
    (
        "NPL-1.0",
        "Netscape Public License v1.0",
        "https://spdx.org/licenses/NPL-1.0.html",
        True,
    ),
    (
        "NPL-1.1",
        "Netscape Public License v1.1",
        "https://spdx.org/licenses/NPL-1.1.html",
        True,
    ),
    (
        "Newsletr",
        "Newsletr License",
        "https://spdx.org/licenses/Newsletr.html",
        False,
    ),
    (
        "ngrep",
        "ngrep License",
        "https://spdx.org/licenses/ngrep.html",
        False,
    ),
    (
        "NICTA-1.0",
        "NICTA Public Software License, Version 1.0",
        "https://spdx.org/licenses/NICTA-1.0.html",
        False,
    ),
    (
        "NIST-PD-TNT",
        "NIST    Public Domain Notice TNT variant",
        "https://spdx.org/licenses/NIST-PD-TNT.html",
        False,
    ),
    (
        "NIST-PD",
        "NIST Public Domain Notice",
        "https://spdx.org/licenses/NIST-PD.html",
        False,
    ),
    (
        "NIST-PD-fallback",
        "NIST Public Domain Notice with license fallback",
        "https://spdx.org/licenses/NIST-PD-fallback.html",
        False,
    ),
    (
        "NIST-Software",
        "NIST Software License",
        "https://spdx.org/licenses/NIST-Software.html",
        False,
    ),
    (
        "NLPL",
        "No Limit Public License",
        "https://spdx.org/licenses/NLPL.html",
        False,
    ),
    (
        "Nokia",
        "Nokia Open Source License",
        "https://spdx.org/licenses/Nokia.html",
        True,
    ),
    (
        "NCGL-UK-2.0",
        "Non-Commercial Government Licence",
        "https://spdx.org/licenses/NCGL-UK-2.0.html",
        False,
    ),
    (
        "NPOSL-3.0",
        "Non-Profit Open Software License 3.0",
        "https://spdx.org/licenses/NPOSL-3.0.html",
        True,
    ),
    (
        "NLOD-1.0",
        "Norwegian Licence for Open Government Data (NLOD) 1.0",
        "https://spdx.org/licenses/NLOD-1.0.html",
        False,
    ),
    (
        "NLOD-2.0",
        "Norwegian Licence for Open Government Data (NLOD) 2.0",
        "https://spdx.org/licenses/NLOD-2.0.html",
        False,
    ),
    (
        "Noweb",
        "Noweb License",
        "https://spdx.org/licenses/Noweb.html",
        False,
    ),
    (
        "NRL",
        "NRL License",
        "https://spdx.org/licenses/NRL.html",
        False,
    ),
    (
        "NTIA-PD",
        "NTIA Public Domain Notice",
        "https://spdx.org/licenses/NTIA-PD.html",
        False,
    ),
    (
        "NTP",
        "NTP License",
        "https://spdx.org/licenses/NTP.html",
        True,
    ),
    (
        "NTP-0",
        "NTP No Attribution",
        "https://spdx.org/licenses/NTP-0.html",
        False,
    ),
    (
        "OAR",
        "OAR License",
        "https://spdx.org/licenses/OAR.html",
        False,
    ),
    (
        "OCLC-2.0",
        "OCLC Research Public License 2.0",
        "https://spdx.org/licenses/OCLC-2.0.html",
        True,
    ),
    (
        "OFFIS",
        "OFFIS License",
        "https://spdx.org/licenses/OFFIS.html",
        False,
    ),
    (
        "OGC-1.0",
        "OGC Software License, Version 1.0",
        "https://spdx.org/licenses/OGC-1.0.html",
        False,
    ),
    (
        "OCCT-PL",
        "Open CASCADE Technology Public License",
        "https://spdx.org/licenses/OCCT-PL.html",
        False,
    ),
    (
        "ODC-By-1.0",
        "Open Data Commons Attribution License v1.0",
        "https://spdx.org/licenses/ODC-By-1.0.html",
        False,
    ),
    (
        "ODbL-1.0",
        "Open Data Commons Open Database License v1.0",
        "https://spdx.org/licenses/ODbL-1.0.html",
        True,
    ),
    (
        "PDDL-1.0",
        "Open Data Commons Public Domain Dedication & License 1.0",
        "https://spdx.org/licenses/PDDL-1.0.html",
        False,
    ),
    (
        "OGL-Canada-2.0",
        "Open Government Licence - Canada",
        "https://spdx.org/licenses/OGL-Canada-2.0.html",
        False,
    ),
    (
        "OGL-UK-1.0",
        "Open Government Licence v1.0",
        "https://spdx.org/licenses/OGL-UK-1.0.html",
        False,
    ),
    (
        "OGL-UK-2.0",
        "Open Government Licence v2.0",
        "https://spdx.org/licenses/OGL-UK-2.0.html",
        False,
    ),
    (
        "OGL-UK-3.0",
        "Open Government Licence v3.0",
        "https://spdx.org/licenses/OGL-UK-3.0.html",
        False,
    ),
    (
        "OGTSL",
        "Open Group Test Suite License",
        "https://spdx.org/licenses/OGTSL.html",
        True,
    ),
    (
        "OLDAP-2.2.2",
        "Open LDAP Public License 2.2.2",
        "https://spdx.org/licenses/OLDAP-2.2.2.html",
        False,
    ),
    (
        "OLDAP-1.1",
        "Open LDAP Public License v1.1",
        "https://spdx.org/licenses/OLDAP-1.1.html",
        False,
    ),
    (
        "OLDAP-1.2",
        "Open LDAP Public License v1.2",
        "https://spdx.org/licenses/OLDAP-1.2.html",
        False,
    ),
    (
        "OLDAP-1.3",
        "Open LDAP Public License v1.3",
        "https://spdx.org/licenses/OLDAP-1.3.html",
        False,
    ),
    (
        "OLDAP-1.4",
        "Open LDAP Public License v1.4",
        "https://spdx.org/licenses/OLDAP-1.4.html",
        False,
    ),
    (
        "OLDAP-2.0",
        "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)",
        "https://spdx.org/licenses/OLDAP-2.0.html",
        False,
    ),
    (
        "OLDAP-2.0.1",
        "Open LDAP Public License v2.0.1",
        "https://spdx.org/licenses/OLDAP-2.0.1.html",
        False,
    ),
    (
        "OLDAP-2.1",
        "Open LDAP Public License v2.1",
        "https://spdx.org/licenses/OLDAP-2.1.html",
        False,
    ),
    (
        "OLDAP-2.2",
        "Open LDAP Public License v2.2",
        "https://spdx.org/licenses/OLDAP-2.2.html",
        False,
    ),
    (
        "OLDAP-2.2.1",
        "Open LDAP Public License v2.2.1",
        "https://spdx.org/licenses/OLDAP-2.2.1.html",
        False,
    ),
    (
        "OLDAP-2.3",
        "Open LDAP Public License v2.3",
        "https://spdx.org/licenses/OLDAP-2.3.html",
        True,
    ),
    (
        "OLDAP-2.4",
        "Open LDAP Public License v2.4",
        "https://spdx.org/licenses/OLDAP-2.4.html",
        False,
    ),
    (
        "OLDAP-2.5",
        "Open LDAP Public License v2.5",
        "https://spdx.org/licenses/OLDAP-2.5.html",
        False,
    ),
    (
        "OLDAP-2.6",
        "Open LDAP Public License v2.6",
        "https://spdx.org/licenses/OLDAP-2.6.html",
        False,
    ),
    (
        "OLDAP-2.7",
        "Open LDAP Public License v2.7",
        "https://spdx.org/licenses/OLDAP-2.7.html",
        True,
    ),
    (
        "OLDAP-2.8",
        "Open LDAP Public License v2.8",
        "https://spdx.org/licenses/OLDAP-2.8.html",
        True,
    ),
    (
        "OLFL-1.3",
        "Open Logistics Foundation License Version 1.3",
        "https://spdx.org/licenses/OLFL-1.3.html",
        True,
    ),
    (
        "OML",
        "Open Market License",
        "https://spdx.org/licenses/OML.html",
        False,
    ),
    (
        "OPL-1.0",
        "Open Public License v1.0",
        "https://spdx.org/licenses/OPL-1.0.html",
        False,
    ),
    (
        "OPUBL-1.0",
        "Open Publication License v1.0",
        "https://spdx.org/licenses/OPUBL-1.0.html",
        False,
    ),
    (
        "OSL-1.0",
        "Open Software License 1.0",
        "https://spdx.org/licenses/OSL-1.0.html",
        True,
    ),
    (
        "OSL-1.1",
        "Open Software License 1.1",
        "https://spdx.org/licenses/OSL-1.1.html",
        True,
    ),
    (
        "OSL-2.0",
        "Open Software License 2.0",
        "https://spdx.org/licenses/OSL-2.0.html",
        True,
    ),
    (
        "OSL-2.1",
        "Open Software License 2.1",
        "https://spdx.org/licenses/OSL-2.1.html",
        True,
    ),
    (
        "OSL-3.0",
        "Open Software License 3.0",
        "https://spdx.org/licenses/OSL-3.0.html",
        True,
    ),
    (
        "O-UDA-1.0",
        "Open Use of Data Agreement v1.0",
        "https://spdx.org/licenses/O-UDA-1.0.html",
        False,
    ),
    (
        "OpenPBS-2.3",
        "OpenPBS v2.3 Software License",
        "https://spdx.org/licenses/OpenPBS-2.3.html",
        False,
    ),
    (
        "OpenSSL",
        "OpenSSL License",
        "https://spdx.org/licenses/OpenSSL.html",
        True,
    ),
    (
        "OpenSSL-standalone",
        "OpenSSL License - standalone",
        "https://spdx.org/licenses/OpenSSL-standalone.html",
        False,
    ),
    (
        "OpenVision",
        "OpenVision License",
        "https://spdx.org/licenses/OpenVision.html",
        False,
    ),
    (
        "OSET-PL-2.1",
        "OSET Public License version 2.1",
        "https://spdx.org/licenses/OSET-PL-2.1.html",
        True,
    ),
    (
        "OSSP",
        "OSSP License",
        "https://spdx.org/licenses/OSSP.html",
        False,
    ),
    (
        "PADL",
        "PADL License",
        "https://spdx.org/licenses/PADL.html",
        False,
    ),
    (
        "PPL",
        "Peer Production License",
        "https://spdx.org/licenses/PPL.html",
        False,
    ),
    (
        "PHP-3.0",
        "PHP License v3.0",
        "https://spdx.org/licenses/PHP-3.0.html",
        True,
    ),
    (
        "PHP-3.01",
        "PHP License v3.01",
        "https://spdx.org/licenses/PHP-3.01.html",
        True,
    ),
    (
        "Pixar",
        "Pixar License",
        "https://spdx.org/licenses/Pixar.html",
        False,
    ),
    (
        "pkgconf",
        "pkgconf License",
        "https://spdx.org/licenses/pkgconf.html",
        False,
    ),
    (
        "Plexus",
        "Plexus Classworlds License",
        "https://spdx.org/licenses/Plexus.html",
        False,
    ),
    (
        "libpng-1.6.35",
        "PNG Reference Library License v1 (for libpng 0.5 through 1.6.35)",
        "https://spdx.org/licenses/libpng-1.6.35.html",
        False,
    ),
    (
        "libpng-2.0",
        "PNG Reference Library version 2",
        "https://spdx.org/licenses/libpng-2.0.html",
        False,
    ),
    (
        "pnmstitch",
        "pnmstitch License",
        "https://spdx.org/licenses/pnmstitch.html",
        False,
    ),
    (
        "PolyForm-Noncommercial-1.0.0",
        "PolyForm Noncommercial License 1.0.0",
        "https://spdx.org/licenses/PolyForm-Noncommercial-1.0.0.html",
        False,
    ),
    (
        "PolyForm-Small-Business-1.0.0",
        "PolyForm Small Business License 1.0.0",
        "https://spdx.org/licenses/PolyForm-Small-Business-1.0.0.html",
        False,
    ),
    (
        "PostgreSQL",
        "PostgreSQL License",
        "https://spdx.org/licenses/PostgreSQL.html",
        True,
    ),
    (
        "psfrag",
        "psfrag License",
        "https://spdx.org/licenses/psfrag.html",
        False,
    ),
    (
        "psutils",
        "psutils License",
        "https://spdx.org/licenses/psutils.html",
        False,
    ),
    (
        "python-ldap",
        "Python ldap License",
        "https://spdx.org/licenses/python-ldap.html",
        False,
    ),
    (
        "Python-2.0",
        "Python License 2.0",
        "https://spdx.org/licenses/Python-2.0.html",
        True,
    ),
    (
        "Python-2.0.1",
        "Python License 2.0.1",
        "https://spdx.org/licenses/Python-2.0.1.html",
        False,
    ),
    (
        "PSF-2.0",
        "Python Software Foundation License 2.0",
        "https://spdx.org/licenses/PSF-2.0.html",
        False,
    ),
    (
        "QPL-1.0",
        "Q Public License 1.0",
        "https://spdx.org/licenses/QPL-1.0.html",
        True,
    ),
    (
        "QPL-1.0-INRIA-2004",
        "Q Public License 1.0 - INRIA 2004 variant",
        "https://spdx.org/licenses/QPL-1.0-INRIA-2004.html",
        False,
    ),
    (
        "Qhull",
        "Qhull License",
        "https://spdx.org/licenses/Qhull.html",
        False,
    ),
    (
        "radvd",
        "radvd License",
        "https://spdx.org/licenses/radvd.html",
        False,
    ),
    (
        "Rdisc",
        "Rdisc License",
        "https://spdx.org/licenses/Rdisc.html",
        False,
    ),
    (
        "RPSL-1.0",
        "RealNetworks Public Source License v1.0",
        "https://spdx.org/licenses/RPSL-1.0.html",
        True,
    ),
    (
        "RPL-1.1",
        "Reciprocal Public License 1.1",
        "https://spdx.org/licenses/RPL-1.1.html",
        True,
    ),
    (
        "RPL-1.5",
        "Reciprocal Public License 1.5",
        "https://spdx.org/licenses/RPL-1.5.html",
        True,
    ),
    (
        "RHeCos-1.1",
        "Red Hat eCos Public License v1.1",
        "https://spdx.org/licenses/RHeCos-1.1.html",
        False,
    ),
    (
        "RSCPL",
        "Ricoh Source Code Public License",
        "https://spdx.org/licenses/RSCPL.html",
        True,
    ),
    (
        "RSA-MD",
        "RSA Message-Digest License",
        "https://spdx.org/licenses/RSA-MD.html",
        False,
    ),
    (
        "Ruby",
        "Ruby License",
        "https://spdx.org/licenses/Ruby.html",
        True,
    ),
    (
        "Ruby-pty",
        "Ruby pty extension license",
        "https://spdx.org/licenses/Ruby-pty.html",
        False,
    ),
    (
        "SAX-PD",
        "Sax Public Domain Notice",
        "https://spdx.org/licenses/SAX-PD.html",
        False,
    ),
    (
        "SAX-PD-2.0",
        "Sax Public Domain Notice 2.0",
        "https://spdx.org/licenses/SAX-PD-2.0.html",
        False,
    ),
    (
        "Saxpath",
        "Saxpath License",
        "https://spdx.org/licenses/Saxpath.html",
        False,
    ),
    (
        "SCEA",
        "SCEA Shared Source License",
        "https://spdx.org/licenses/SCEA.html",
        False,
    ),
    (
        "SchemeReport",
        "Scheme Language Report License",
        "https://spdx.org/licenses/SchemeReport.html",
        False,
    ),
    (
        "SWL",
        "Scheme Widget Library (SWL) Software License Agreement",
        "https://spdx.org/licenses/SWL.html",
        False,
    ),
    (
        "SMPPL",
        "Secure Messaging Protocol Public License",
        "https://spdx.org/licenses/SMPPL.html",
        False,
    ),
    (
        "Sendmail",
        "Sendmail License",
        "https://spdx.org/licenses/Sendmail.html",
        False,
    ),
    (
        "Sendmail-8.23",
        "Sendmail License 8.23",
        "https://spdx.org/licenses/Sendmail-8.23.html",
        False,
    ),
    (
        "Sendmail-Open-Source-1.1",
        "Sendmail Open Source License v1.1",
        "https://spdx.org/licenses/Sendmail-Open-Source-1.1.html",
        False,
    ),
    (
        "SSPL-1.0",
        "Server Side Public License, v 1",
        "https://spdx.org/licenses/SSPL-1.0.html",
        False,
    ),
    (
        "SGI-B-1.0",
        "SGI Free Software License B v1.0",
        "https://spdx.org/licenses/SGI-B-1.0.html",
        False,
    ),
    (
        "SGI-B-1.1",
        "SGI Free Software License B v1.1",
        "https://spdx.org/licenses/SGI-B-1.1.html",
        False,
    ),
    (
        "SGI-B-2.0",
        "SGI Free Software License B v2.0",
        "https://spdx.org/licenses/SGI-B-2.0.html",
        True,
    ),
    (
        "SGI-OpenGL",
        "SGI OpenGL License",
        "https://spdx.org/licenses/SGI-OpenGL.html",
        False,
    ),
    (
        "SGMLUG-PM",
        "SGMLUG Parser Materials License",
        "https://spdx.org/licenses/SGMLUG-PM.html",
        False,
    ),
    (
        "SGP4",
        "SGP4 Permission Notice",
        "https://spdx.org/licenses/SGP4.html",
        False,
    ),
    (
        "OFL-1.0",
        "SIL Open Font License 1.0",
        "https://spdx.org/licenses/OFL-1.0.html",
        True,
    ),
    (
        "OFL-1.0-no-RFN",
        "SIL Open Font License 1.0 with no Reserved Font Name",
        "https://spdx.org/licenses/OFL-1.0-no-RFN.html",
        False,
    ),
    (
        "OFL-1.0-RFN",
        "SIL Open Font License 1.0 with Reserved Font Name",
        "https://spdx.org/licenses/OFL-1.0-RFN.html",
        False,
    ),
    (
        "OFL-1.1",
        "SIL Open Font License 1.1",
        "https://spdx.org/licenses/OFL-1.1.html",
        True,
    ),
    (
        "OFL-1.1-no-RFN",
        "SIL Open Font License 1.1 with no Reserved Font Name",
        "https://spdx.org/licenses/OFL-1.1-no-RFN.html",
        True,
    ),
    (
        "OFL-1.1-RFN",
        "SIL Open Font License 1.1 with Reserved Font Name",
        "https://spdx.org/licenses/OFL-1.1-RFN.html",
        True,
    ),
    (
        "SimPL-2.0",
        "Simple Public License 2.0",
        "https://spdx.org/licenses/SimPL-2.0.html",
        True,
    ),
    (
        "SL",
        "SL License",
        "https://spdx.org/licenses/SL.html",
        False,
    ),
    (
        "Sleepycat",
        "Sleepycat License",
        "https://spdx.org/licenses/Sleepycat.html",
        True,
    ),
    (
        "SMAIL-GPL",
        "SMAIL General Public License",
        "https://spdx.org/licenses/SMAIL-GPL.html",
        False,
    ),
    (
        "SNIA",
        "SNIA Public License 1.1",
        "https://spdx.org/licenses/SNIA.html",
        False,
    ),
    (
        "snprintf",
        "snprintf License",
        "https://spdx.org/licenses/snprintf.html",
        False,
    ),
    (
        "SOFA",
        "SOFA Software License",
        "https://spdx.org/licenses/SOFA.html",
        False,
    ),
    (
        "softSurfer",
        "softSurfer License",
        "https://spdx.org/licenses/softSurfer.html",
        False,
    ),
    (
        "SHL-0.5",
        "Solderpad Hardware License v0.5",
        "https://spdx.org/licenses/SHL-0.5.html",
        False,
    ),
    (
        "SHL-0.51",
        "Solderpad Hardware License, Version 0.51",
        "https://spdx.org/licenses/SHL-0.51.html",
        False,
    ),
    (
        "Soundex",
        "Soundex License",
        "https://spdx.org/licenses/Soundex.html",
        False,
    ),
    (
        "Spencer-86",
        "Spencer License 86",
        "https://spdx.org/licenses/Spencer-86.html",
        False,
    ),
    (
        "Spencer-94",
        "Spencer License 94",
        "https://spdx.org/licenses/Spencer-94.html",
        False,
    ),
    (
        "Spencer-99",
        "Spencer License 99",
        "https://spdx.org/licenses/Spencer-99.html",
        False,
    ),
    (
        "blessing",
        "SQLite Blessing",
        "https://spdx.org/licenses/blessing.html",
        False,
    ),
    (
        "SSH-OpenSSH",
        "SSH OpenSSH license",
        "https://spdx.org/licenses/SSH-OpenSSH.html",
        False,
    ),
    (
        "SSH-short",
        "SSH short notice",
        "https://spdx.org/licenses/SSH-short.html",
        False,
    ),
    (
        "ssh-keyscan",
        "ssh-keyscan License",
        "https://spdx.org/licenses/ssh-keyscan.html",
        False,
    ),
    (
        "SSLeay-standalone",
        "SSLeay License - standalone",
        "https://spdx.org/licenses/SSLeay-standalone.html",
        False,
    ),
    (
        "SMLNJ",
        "Standard ML of New Jersey License",
        "https://spdx.org/licenses/SMLNJ.html",
        True,
    ),
    (
        "SugarCRM-1.1.3",
        "SugarCRM Public License v1.1.3",
        "https://spdx.org/licenses/SugarCRM-1.1.3.html",
        False,
    ),
    (
        "SISSL",
        "Sun Industry Standards Source License v1.1",
        "https://spdx.org/licenses/SISSL.html",
        True,
    ),
    (
        "SISSL-1.2",
        "Sun Industry Standards Source License v1.2",
        "https://spdx.org/licenses/SISSL-1.2.html",
        False,
    ),
    (
        "Sun-PPP",
        "Sun PPP License",
        "https://spdx.org/licenses/Sun-PPP.html",
        False,
    ),
    (
        "Sun-PPP-2000",
        "Sun PPP License (2000)",
        "https://spdx.org/licenses/Sun-PPP-2000.html",
        False,
    ),
    (
        "SPL-1.0",
        "Sun Public License v1.0",
        "https://spdx.org/licenses/SPL-1.0.html",
        True,
    ),
    (
        "SunPro",
        "SunPro License",
        "https://spdx.org/licenses/SunPro.html",
        False,
    ),
    (
        "SUL-1.0",
        "Sustainable Use License v1.0",
        "https://spdx.org/licenses/SUL-1.0.html",
        False,
    ),
    (
        "swrule",
        "swrule License",
        "https://spdx.org/licenses/swrule.html",
        False,
    ),
    (
        "Watcom-1.0",
        "Sybase Open Watcom Public License 1.0",
        "https://spdx.org/licenses/Watcom-1.0.html",
        True,
    ),
    (
        "Symlinks",
        "Symlinks License",
        "https://spdx.org/licenses/Symlinks.html",
        False,
    ),
    (
        "BSD-Systemics",
        "Systemics BSD variant license",
        "https://spdx.org/licenses/BSD-Systemics.html",
        False,
    ),
    (
        "BSD-Systemics-W3Works",
        "Systemics W3Works BSD variant license",
        "https://spdx.org/licenses/BSD-Systemics-W3Works.html",
        False,
    ),
    (
        "OGDL-Taiwan-1.0",
        "Taiwan Open Government Data License, version 1.0",
        "https://spdx.org/licenses/OGDL-Taiwan-1.0.html",
        False,
    ),
    (
        "TAPR-OHL-1.0",
        "TAPR Open Hardware License v1.0",
        "https://spdx.org/licenses/TAPR-OHL-1.0.html",
        False,
    ),
    (
        "TCL",
        "TCL/TK License",
        "https://spdx.org/licenses/TCL.html",
        False,
    ),
    (
        "TCP-wrappers",
        "TCP Wrappers License",
        "https://spdx.org/licenses/TCP-wrappers.html",
        False,
    ),
    (
        "TU-Berlin-1.0",
        "Technische Universitaet Berlin License 1.0",
        "https://spdx.org/licenses/TU-Berlin-1.0.html",
        False,
    ),
    (
        "TU-Berlin-2.0",
        "Technische Universitaet Berlin License 2.0",
        "https://spdx.org/licenses/TU-Berlin-2.0.html",
        False,
    ),
    (
        "TermReadKey",
        "TermReadKey License",
        "https://spdx.org/licenses/TermReadKey.html",
        False,
    ),
    (
        "TTWL",
        "Text-Tabs+Wrap License",
        "https://spdx.org/licenses/TTWL.html",
        False,
    ),
    (
        "MirOS",
        "The MirOS Licence",
        "https://spdx.org/licenses/MirOS.html",
        True,
    ),
    (
        "Parity-6.0.0",
        "The Parity Public License 6.0.0",
        "https://spdx.org/licenses/Parity-6.0.0.html",
        False,
    ),
    (
        "Parity-7.0.0",
        "The Parity Public License 7.0.0",
        "https://spdx.org/licenses/Parity-7.0.0.html",
        False,
    ),
    (
        "Unlicense",
        "The Unlicense",
        "https://spdx.org/licenses/Unlicense.html",
        True,
    ),
    (
        "ThirdEye",
        "ThirdEye License",
        "https://spdx.org/licenses/ThirdEye.html",
        False,
    ),
    (
        "TPL-1.0",
        "THOR Public License 1.0",
        "https://spdx.org/licenses/TPL-1.0.html",
        False,
    ),
    (
        "threeparttable",
        "threeparttable License",
        "https://spdx.org/licenses/threeparttable.html",
        False,
    ),
    (
        "TPDL",
        "Time::ParseDate License",
        "https://spdx.org/licenses/TPDL.html",
        False,
    ),
    (
        "TMate",
        "TMate Open Source License",
        "https://spdx.org/licenses/TMate.html",
        False,
    ),
    (
        "TORQUE-1.1",
        "TORQUE v2.5+ Software License v1.1",
        "https://spdx.org/licenses/TORQUE-1.1.html",
        False,
    ),
    (
        "TGPPL-1.0",
        "Transitive Grace Period Public Licence 1.0",
        "https://spdx.org/licenses/TGPPL-1.0.html",
        False,
    ),
    (
        "TOSL",
        "Trusster Open Source License",
        "https://spdx.org/licenses/TOSL.html",
        False,
    ),
    (
        "TrustedQSL",
        "TrustedQSL License",
        "https://spdx.org/licenses/TrustedQSL.html",
        False,
    ),
    (
        "TTYP0",
        "TTYP0 License",
        "https://spdx.org/licenses/TTYP0.html",
        False,
    ),
    (
        "Ubuntu-font-1.0",
        "Ubuntu Font Licence v1.0",
        "https://spdx.org/licenses/Ubuntu-font-1.0.html",
        False,
    ),
    (
        "UCAR",
        "UCAR License",
        "https://spdx.org/licenses/UCAR.html",
        False,
    ),
    (
        "ulem",
        "ulem License",
        "https://spdx.org/licenses/ulem.html",
        False,
    ),
    (
        "Unicode-DFS-2015",
        "Unicode License Agreement - Data Files and Software (2015)",
        "https://spdx.org/licenses/Unicode-DFS-2015.html",
        False,
    ),
    (
        "Unicode-DFS-2016",
        "Unicode License Agreement - Data Files and Software (2016)",
        "https://spdx.org/licenses/Unicode-DFS-2016.html",
        True,
    ),
    (
        "Unicode-3.0",
        "Unicode License v3",
        "https://spdx.org/licenses/Unicode-3.0.html",
        True,
    ),
    (
        "Unicode-TOU",
        "Unicode Terms of Use",
        "https://spdx.org/licenses/Unicode-TOU.html",
        False,
    ),
    (
        "OPL-UK-3.0",
        "United    Kingdom Open Parliament Licence v3.0",
        "https://spdx.org/licenses/OPL-UK-3.0.html",
        False,
    ),
    (
        "UPL-1.0",
        "Universal Permissive License v1.0",
        "https://spdx.org/licenses/UPL-1.0.html",
        True,
    ),
    (
        "NCSA",
        "University of Illinois/NCSA Open Source License",
        "https://spdx.org/licenses/NCSA.html",
        True,
    ),
    (
        "UnixCrypt",
        "UnixCrypt License",
        "https://spdx.org/licenses/UnixCrypt.html",
        False,
    ),
    (
        "Unlicense-libtelnet",
        "Unlicense - libtelnet variant",
        "https://spdx.org/licenses/Unlicense-libtelnet.html",
        False,
    ),
    (
        "Unlicense-libwhirlpool",
        "Unlicense - libwhirlpool variant",
        "https://spdx.org/licenses/Unlicense-libwhirlpool.html",
        False,
    ),
    (
        "UCL-1.0",
        "Upstream Compatibility License v1.0",
        "https://spdx.org/licenses/UCL-1.0.html",
        True,
    ),
    (
        "URT-RLE",
        "Utah Raster Toolkit Run Length Encoded License",
        "https://spdx.org/licenses/URT-RLE.html",
        False,
    ),
    (
        "Vim",
        "Vim License",
        "https://spdx.org/licenses/Vim.html",
        True,
    ),
    (
        "VOSTROM",
        "VOSTROM Public License for Open Source",
        "https://spdx.org/licenses/VOSTROM.html",
        False,
    ),
    (
        "VSL-1.0",
        "Vovida Software License v1.0",
        "https://spdx.org/licenses/VSL-1.0.html",
        True,
    ),
    (
        "W3C-20150513",
        "W3C Software Notice and Document License (2015-05-13)",
        "https://spdx.org/licenses/W3C-20150513.html",
        True,
    ),
    (
        "W3C-19980720",
        "W3C Software Notice and License (1998-07-20)",
        "https://spdx.org/licenses/W3C-19980720.html",
        False,
    ),
    (
        "W3C",
        "W3C Software Notice and License (2002-12-31)",
        "https://spdx.org/licenses/W3C.html",
        True,
    ),
    (
        "w3m",
        "w3m License",
        "https://spdx.org/licenses/w3m.html",
        False,
    ),
    (
        "Widget-Workshop",
        "Widget Workshop License",
        "https://spdx.org/licenses/Widget-Workshop.html",
        False,
    ),
    (
        "WordNet",
        "WordNet License",
        "https://spdx.org/licenses/WordNet.html",
        True,
    ),
    (
        "Wsuipa",
        "Wsuipa License",
        "https://spdx.org/licenses/Wsuipa.html",
        False,
    ),
    (
        "wwl",
        "WWL License",
        "https://spdx.org/licenses/wwl.html",
        False,
    ),
    (
        "Xnet",
        "X.Net License",
        "https://spdx.org/licenses/Xnet.html",
        True,
    ),
    (
        "X11",
        "X11 License",
        "https://spdx.org/licenses/X11.html",
        True,
    ),
    (
        "X11-distribute-modifications-variant",
        "X11 License Distribution Modification Variant",
        "https://spdx.org/licenses/X11-distribute-modifications-variant.html",
        False,
    ),
    (
        "X11-swapped",
        "X11 swapped final paragraphs",
        "https://spdx.org/licenses/X11-swapped.html",
        False,
    ),
    (
        "Xdebug-1.03",
        "Xdebug License v 1.03",
        "https://spdx.org/licenses/Xdebug-1.03.html",
        False,
    ),
    (
        "Xerox",
        "Xerox License",
        "https://spdx.org/licenses/Xerox.html",
        False,
    ),
    (
        "Xfig",
        "Xfig License",
        "https://spdx.org/licenses/Xfig.html",
        False,
    ),
    (
        "XFree86-1.1",
        "XFree86 License 1.1",
        "https://spdx.org/licenses/XFree86-1.1.html",
        True,
    ),
    (
        "xinetd",
        "xinetd License",
        "https://spdx.org/licenses/xinetd.html",
        True,
    ),
    (
        "xkeyboard-config-Zinoviev",
        "xkeyboard-config Zinoviev License",
        "https://spdx.org/licenses/xkeyboard-config-Zinoviev.html",
        False,
    ),
    (
        "xlock",
        "xlock License",
        "https://spdx.org/licenses/xlock.html",
        False,
    ),
    (
        "xpp",
        "XPP License",
        "https://spdx.org/licenses/xpp.html",
        False,
    ),
    (
        "XSkat",
        "XSkat License",
        "https://spdx.org/licenses/XSkat.html",
        False,
    ),
    (
        "xzoom",
        "xzoom License",
        "https://spdx.org/licenses/xzoom.html",
        False,
    ),
    (
        "YPL-1.0",
        "Yahoo! Public License v1.0",
        "https://spdx.org/licenses/YPL-1.0.html",
        False,
    ),
    (
        "YPL-1.1",
        "Yahoo! Public License v1.1",
        "https://spdx.org/licenses/YPL-1.1.html",
        True,
    ),
    (
        "Zed",
        "Zed License",
        "https://spdx.org/licenses/Zed.html",
        False,
    ),
    (
        "Zeeff",
        "Zeeff License",
        "https://spdx.org/licenses/Zeeff.html",
        False,
    ),
    (
        "Zend-2.0",
        "Zend License v2.0",
        "https://spdx.org/licenses/Zend-2.0.html",
        True,
    ),
    (
        "Zimbra-1.3",
        "Zimbra Public License v1.3",
        "https://spdx.org/licenses/Zimbra-1.3.html",
        True,
    ),
    (
        "Zimbra-1.4",
        "Zimbra Public License v1.4",
        "https://spdx.org/licenses/Zimbra-1.4.html",
        False,
    ),
    (
        "Zlib",
        "zlib License",
        "https://spdx.org/licenses/Zlib.html",
        True,
    ),
    (
        "zlib-acknowledgement",
        "zlib/libpng License with Acknowledgement",
        "https://spdx.org/licenses/zlib-acknowledgement.html",
        False,
    ),
    (
        "ZPL-1.1",
        "Zope Public License 1.1",
        "https://spdx.org/licenses/ZPL-1.1.html",
        False,
    ),
    (
        "ZPL-2.0",
        "Zope Public License 2.0",
        "https://spdx.org/licenses/ZPL-2.0.html",
        True,
    ),
    (
        "ZPL-2.1",
        "Zope Public License 2.1",
        "https://spdx.org/licenses/ZPL-2.1.html",
        True,
    ),
)
