# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.1.7 on 2025-04-09 10:54

from django.db import migrations

from weblate.configuration.models import SettingCategory


def update_default_focus_color(apps, schema_editor) -> None:
    """Update the default focus color in the AppearanceForm."""
    Setting = apps.get_model("configuration", "Setting")
    Setting.objects.filter(
        category=SettingCategory.UI, name="focus_color", value="#2eccaa,#1ebc9a"
    ).update(value="#2eccaa,#25303b")


class Migration(migrations.Migration):
    dependencies = [
        ("wladmin", "0001_squashed_weblate_5"),
    ]

    operations = [
        migrations.RunPython(update_default_focus_color),
    ]
