# Project Samples

## [Calculator agent](calculator-agent)
This sample demonstrates a simple LangGraph agent that performs basic arithmetic operations and showcases nested traced invocations.

## [Chat agent](chat-agent)
This sample shows how to build an AI assistant using LangGraph and Tavily search for movie research and recommendations.

## [Company research agent](company-research-agent)
This sample demonstrates how to create an agent that researches companies and develops outreach strategies using web search capabilities.

## [Email organizer agent](email-organizer-agent)
This sample shows how to automate Outlook inbox organization with AI-powered rule suggestions and human-in-the-loop approval.

## [HITL inbox server](hitl-inbox-server)
This sample demonstrates a FastAPI server for managing human-in-the-loop workflows with job submissions and inbox message approvals.

## [Multi agent supervisor, researcher, coder](multi-agent-supervisor-researcher-coder)
This sample showcases a multi-agent system, involving a supervisor, a researcher, and a coder working in coordination to tackle complex tasks.

## [Multi agent planner, researcher, coder distributed](multi-agent-planner-researcher-coder-distributed)
Here, a multi-agent system breaks down complex tasks into discreet steps, routing them to specialized agents. Each agent operates **independently** and can be deployed as a separate process. The system includes a planner, researcher, and coder agent.

## [RAG-quiz-generator](RAG-quiz-generator)
The RAG Sample project demonstrates the implementation of a Retrieval-Augmented Generation (RAG) system using [UiPath Context Grounding](https://docs.uipath.com/automation-cloud/automation-cloud/latest/admin-guide/about-context-grounding).

## [Retrieval chain](retrieval-chain)
This example shows how to retrieve relevant documents for a query, using the UiPath Context Grounding vectorstore. It also integrates this into a Langchain retrieval chain for response formulation.

## [Simple local MCP](simple-local-mcp)
This sample shows how to create an agent using LangGraph with multiple tool servers via the MCP (Model Context Protocol) standard.

## [Simple remote MCP](simple-remote-mcp)
This sample demonstrates the creation of an agent using LangGraph, which connects to a remote MCP (Model Context Protocol) Server.

## [Simple DeepAgent](simple-deepagent)
This sample demonstrates using the DeepAgents library to create an agent with advanced planning, sub-agent delegation, and web search capabilities.

## [OAuth external apps agent](oauth-external-apps-agent)
This sample shows how to build a LangGraph agent that connects to a remote UiPath MCP server using OAuth authentication through an external UiPath application for dynamic access token management.

## [Ticket classification](ticket-classification)
This sample demonstrates automatic classification of support tickets into categories. It includes a human approval step via UiPath Action Center.
