"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const rds_generated_1 = require("./rds.generated");
/**
 * A parameter group.
 * Represents both a cluster parameter group,
 * and an instance parameter group.
 *
 * @resource AWS::RDS::DBParameterGroup
 */
class ParameterGroup extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_ParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ParameterGroup);
            }
            throw error;
        }
        const family = props.engine.parameterGroupFamily;
        if (!family) {
            throw new Error("ParameterGroup cannot be used with an engine that doesn't specify a version");
        }
        this.family = family;
        this.description = props.description;
        this.parameters = props.parameters ?? {};
    }
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope, id, parameterGroupName) {
        class Import extends core_1.Resource {
            bindToCluster(_options) {
                return { parameterGroupName };
            }
            bindToInstance(_options) {
                return { parameterGroupName };
            }
            addParameter(_key, _value) {
                return false;
            }
        }
        return new Import(scope, id);
    }
    bindToCluster(_options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_ParameterGroupClusterBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bindToCluster);
            }
            throw error;
        }
        if (!this.clusterCfnGroup) {
            const id = this.instanceCfnGroup ? 'ClusterParameterGroup' : 'Resource';
            this.clusterCfnGroup = new rds_generated_1.CfnDBClusterParameterGroup(this, id, {
                description: this.description || `Cluster parameter group for ${this.family}`,
                family: this.family,
                parameters: core_1.Lazy.any({ produce: () => this.parameters }),
            });
        }
        return {
            parameterGroupName: this.clusterCfnGroup.ref,
        };
    }
    bindToInstance(_options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_ParameterGroupInstanceBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bindToInstance);
            }
            throw error;
        }
        if (!this.instanceCfnGroup) {
            const id = this.clusterCfnGroup ? 'InstanceParameterGroup' : 'Resource';
            this.instanceCfnGroup = new rds_generated_1.CfnDBParameterGroup(this, id, {
                description: this.description || `Parameter group for ${this.family}`,
                family: this.family,
                parameters: core_1.Lazy.any({ produce: () => this.parameters }),
            });
        }
        return {
            parameterGroupName: this.instanceCfnGroup.ref,
        };
    }
    /**
     * Add a parameter to this parameter group
     *
     * @param key The key of the parameter to be added
     * @param value The value of the parameter to be added
     */
    addParameter(key, value) {
        this.parameters[key] = value;
        return true;
    }
}
exports.ParameterGroup = ParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ParameterGroup[_a] = { fqn: "@aws-cdk/aws-rds.ParameterGroup", version: "1.178.0" };
//# sourceMappingURL=data:application/json;base64,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