"""
Модуль с физическими и математическими константами для конвертера.
Все коэффициенты выражены относительно базовых единиц СИ (Па, К, Дж и т.д.)
для обеспечения единства и простоты проверки.
"""

# --- Давление ---
# 1 кгс/см² (техническая атмосфера) в Паскалях
KGF_PER_CM2_TO_PA = 98066.5
# 1 физическая атмосфера в Паскалях
ATM_TO_PA = 101325.0
# 1 бар в Паскалях
BAR_TO_PA = 100000.0
# 1 мм рт. ст. в Паскалях
MM_HG_TO_PA = 133.322

# --- Температура ---
# Смещение для перевода градусов Цельсия в Кельвины
CELSIUS_TO_KELVIN_OFFSET = 273.15

# --- Энергия, Работа, Теплота (Джоуль) ---
# 1 международная калория в Джоулях
CAL_TO_J = 4.1868
# 1 лошадиная сила (метрическая) в Ваттах
HP_TO_W = 735.49875

# --- Масса и Расход ---
# 1 тонна в час в кг/с
T_PER_H_TO_KG_PER_S = 1000 / 3600.0
