from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class AdministratorCommandLineInterfaceApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def get_admin_cli_release(
        self,
        os: str,
    ):
        r"""


        ### Description
        Get Administrator Command Line Interface release.

        ### Parameters:
        ```python
        os: str
        ```
        os: The operating system

        ### Example:
        ```python
        AdministratorCommandLineInterfaceApi(
            os='os_example'
        )
        ```
        """

        resource_path = f"/v1/k8s/admin_cli/{os}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_admin_cli_release_by_version(
        self,
        os: str,
        version: str,
    ):
        r"""


        ### Description
        Get Administrator Command Line Interface release by version.

        ### Parameters:
        ```python
        os: str
        version: str
        ```
        os: The operating system
        version: run:ai version (semantic version)

        ### Example:
        ```python
        AdministratorCommandLineInterfaceApi(
            os='os_example',
                        version='version_example'
        )
        ```
        """

        resource_path = f"/v1/k8s/admin_cli/{version}/{os}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_admin_cli_release_by_version_checksum(
        self,
        os: str,
        version: str,
    ):
        r"""


        ### Description
        Get Administrator Command Line Interface release checksums.

        ### Parameters:
        ```python
        os: str
        version: str
        ```
        os: The operating system
        version: run:ai version (semantic version)

        ### Example:
        ```python
        AdministratorCommandLineInterfaceApi(
            os='os_example',
                        version='version_example'
        )
        ```
        """

        resource_path = f"/v1/k8s/admin_cli/{version}/{os}/checksum".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_admin_cli_release_checksum(
        self,
        os: str,
    ):
        r"""


        ### Description
        Get Administrator Command Line Interface release details.

        ### Parameters:
        ```python
        os: str
        ```
        os: The operating system

        ### Example:
        ```python
        AdministratorCommandLineInterfaceApi(
            os='os_example'
        )
        ```
        """

        resource_path = f"/v1/k8s/admin_cli/{os}/checksum".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
