from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class AuditLogsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def download_audit_logs(
        self,
        start: datetime,
        end: datetime,
        file_type: Optional[str] = None,
        number_of_samples: Optional[int] = None,
        filter_by: Optional[List[str]] = None,
    ):
        r"""


        ### Description
        Download audit logs

        ### Parameters:
        ```python
        start: Optional[datetime]
        end: Optional[datetime]
        file_type: Optional[str]
        number_of_samples: Optional[int]
        filter_by: Optional[List[str]]
        ```
        start: Start date of time range to fetch data in ISO 8601 timestamp format.
        end: End date of time range to fetch data in ISO 8601 timestamp format.
        file_type: See model str for more information. - Default: CSV
        number_of_samples: The number of samples to take in the specified time range. - Default: 20
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &#x3D;&#x3D; Equals, !&#x3D; Not equals, &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains, !@ Does not contains, &#x3D;^ Starts with and &#x3D;$ Ends with. Dates are in ISO 8601 timestamp format and available for operators &#x3D;&#x3D;, !&#x3D;, &lt;&#x3D; and &gt;&#x3D;.

        ### Example:
        ```python
        AuditLogsApi(
            start='2023-06-06T12:09:18.211Z',
                        end='2023-06-07T12:09:18.211Z',
                        file_type=CSV,
                        number_of_samples=20,
                        filter_by=['[\"cluster_name==my-cluster_name\",\"entity_type==cluster,entity_name==test\"]']
        )
        ```
        """

        # Query params:
        query_params = [
            ("fileType", file_type),
            ("start", start),
            ("end", end),
            ("numberOfSamples", number_of_samples),
            ("filterBy", filter_by),
        ]
        resource_path = f"/api/v1/audit/log/file".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_audit_logs(
        self,
        start: datetime,
        end: datetime,
        offset: Optional[int] = None,
        number_of_samples: Optional[int] = None,
        sort_order: Optional[str] = None,
        sort_by: Optional[str] = None,
        filter_by: Optional[List[str]] = None,
    ):
        r"""


        ### Description
        Get audit logs

        ### Parameters:
        ```python
        start: Optional[datetime]
        end: Optional[datetime]
        offset: Optional[int]
        number_of_samples: Optional[int]
        sort_order: Optional[str]
        sort_by: Optional[str]
        filter_by: Optional[List[str]]
        ```
        start: Start date of time range to fetch data in ISO 8601 timestamp format.
        end: End date of time range to fetch data in ISO 8601 timestamp format.
        offset: The offset of the first item returned in the collection.
        number_of_samples: The number of samples to take in the specified time range. - Default: 20
        sort_order: Sort results in descending or ascending order. - Default: asc
        sort_by: Sort results by a parameters.
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &#x3D;&#x3D; Equals, !&#x3D; Not equals, &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains, !@ Does not contains, &#x3D;^ Starts with and &#x3D;$ Ends with. Dates are in ISO 8601 timestamp format and available for operators &#x3D;&#x3D;, !&#x3D;, &lt;&#x3D; and &gt;&#x3D;.

        ### Example:
        ```python
        AuditLogsApi(
            start='2023-06-06T12:09:18.211Z',
                        end='2023-06-07T12:09:18.211Z',
                        offset=100,
                        number_of_samples=20,
                        sort_order=asc,
                        sort_by='sort_by_example',
                        filter_by=['[\"cluster_name==my-cluster_name\",\"entity_type==cluster,entity_name==test\"]']
        )
        ```
        """

        # Query params:
        query_params = [
            ("start", start),
            ("end", end),
            ("offset", offset),
            ("numberOfSamples", number_of_samples),
            ("sortOrder", sort_order),
            ("sortBy", sort_by),
            ("filterBy", filter_by),
        ]
        resource_path = f"/api/v1/audit/log".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )
