from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class ClustersApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_cluster(
        self,
        cluster_creation_request: models.ClusterCreationRequest,
    ):
        r"""


        ### Description
        Create a cluster.

        ### Parameters:
        ```python
        cluster_creation_request: ClusterCreationRequest
        ```
        cluster_creation_request: The cluster to create.

        ### Example:
        ```python
        ClustersApi(
            cluster_creation_request=runai.ClusterCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = cluster_creation_request

        resource_path = f"/api/v1/clusters".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_cluster(
        self,
        cluster_uuid: str,
        force: Optional[bool] = None,
    ):
        r"""


        ### Description
        Delete a cluster by id.

        ### Parameters:
        ```python
        cluster_uuid: str
        force: Optional[bool]
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        force: if true will force cluster instant deletion otherwise will start cluster graceful deletion process.  - Default: False

        ### Example:
        ```python
        ClustersApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        force=False
        )
        ```
        """

        # Query params:
        query_params = [
            ("force", force),
        ]
        resource_path = f"/api/v1/clusters/{cluster_uuid}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_cluster_by_uuid(
        self,
        cluster_uuid: str,
        verbosity: Optional[str] = None,
    ):
        r"""


        ### Description
        Get cluster by id.

        ### Parameters:
        ```python
        cluster_uuid: str
        verbosity: Optional[str]
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        verbosity: response verbosity level.  - Default: full

        ### Example:
        ```python
        ClustersApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        verbosity=full
        )
        ```
        """

        # Query params:
        query_params = [
            ("verbosity", verbosity),
        ]
        resource_path = f"/api/v1/clusters/{cluster_uuid}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_cluster_install_info_by_uuid(
        self,
        cluster_uuid: str,
        version: str,
        remote_cluster_url: Optional[str] = None,
    ):
        r"""


        ### Description
        Retrieve the installation instructions of a cluster by ID.

        ### Parameters:
        ```python
        cluster_uuid: str
        version: Optional[str]
        remote_cluster_url: Optional[str]
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        version: The cluster version to install
        remote_cluster_url: The remote URL of the runai cluster

        ### Example:
        ```python
        ClustersApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        version='2.16',
                        remote_cluster_url='https://cluster.runai'
        )
        ```
        """

        # Query params:
        query_params = [
            ("version", version),
            ("remoteClusterUrl", remote_cluster_url),
        ]
        resource_path = f"/api/v1/clusters/{cluster_uuid}/cluster_install_info".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_cluster_metrics(
        self,
        cluster_uuid: str,
        start: datetime,
        end: datetime,
        metric_type: List[models.MetricsType],
        number_of_samples: Optional[int] = None,
    ):
        r"""


        ### Description
        Get the cluster metrics data.

        ### Parameters:
        ```python
        cluster_uuid: str
        start: Optional[datetime]
        end: Optional[datetime]
        metric_type: Optional[models.List[MetricsType]]
        number_of_samples: Optional[int]
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        start: Start date of time range to fetch data in ISO 8601 timestamp format.
        end: End date of time range to fetch data in ISO 8601 timestamp format.
        metric_type: specifies what data to request
        number_of_samples: The number of samples to take in the specified time range. - Default: 20

        ### Example:
        ```python
        ClustersApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        start='2023-06-06T12:09:18.211Z',
                        end='2023-06-07T12:09:18.211Z',
                        metric_type=[runai.MetricsType()],
                        number_of_samples=20
        )
        ```
        """

        # Query params:
        query_params = [
            ("start", start),
            ("end", end),
            ("numberOfSamples", number_of_samples),
            ("metricType", metric_type),
        ]
        resource_path = f"/api/v1/clusters/{cluster_uuid}/metrics".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    @deprecated_message()
    def get_cluster_metrics_0(
        self,
        cluster_uuid: str,
        start: Optional[datetime] = None,
        end: Optional[datetime] = None,
        number_of_samples: Optional[int] = None,
        nodepool_name: Optional[str] = None,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get cluster metrics.

        ### Parameters:
        ```python
        cluster_uuid: str
        start: Optional[datetime]
        end: Optional[datetime]
        number_of_samples: Optional[int]
        nodepool_name: Optional[str]
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        start: Start of time range to fetch data from in UTC format.
        end: End of time range to fetch data from in UTC format.
        number_of_samples: The number of samples to take in the specified time range. - Default: 20
        nodepool_name: Filter by unique nodepool name.

        ### Example:
        ```python
        ClustersApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        start='2013-10-20T19:20:30+01:00',
                        end='2013-10-20T19:20:30+01:00',
                        number_of_samples=20,
                        nodepool_name='default'
        )
        ```
        """

        # Query params:
        query_params = [
            ("start", start),
            ("end", end),
            ("numberOfSamples", number_of_samples),
            ("nodepoolName", nodepool_name),
        ]
        resource_path = f"/v1/k8s/clusters/{cluster_uuid}/metrics".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_clusters(
        self,
        verbosity: Optional[str] = None,
        include_requested_for_delete: Optional[bool] = None,
    ):
        r"""


        ### Description
        Get a list of clusters.

        ### Parameters:
        ```python
        verbosity: Optional[str]
        include_requested_for_delete: Optional[bool]
        ```
        verbosity: response verbosity level.  - Default: full
        include_requested_for_delete: When true, includes clusters that are marked for deletion

        ### Example:
        ```python
        ClustersApi(
            verbosity=full,
                        include_requested_for_delete=true
        )
        ```
        """

        # Query params:
        query_params = [
            ("verbosity", verbosity),
            ("includeRequestedForDelete", include_requested_for_delete),
        ]
        resource_path = f"/api/v1/clusters".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_install_file(
        self,
        cluster_uuid: str,
        cloud: Optional[str] = None,
        clusterip: Optional[str] = None,
        format: Optional[str] = None,
    ):
        r"""


        ### Description
        Get cluster installation file by id.

        ### Parameters:
        ```python
        cluster_uuid: str
        cloud: Optional[str]
        clusterip: Optional[str]
        format: Optional[str]
        ```
        cluster_uuid: Unique identifier of the cluster.
        cloud: Cloud type identifier.
        clusterip: Comma-separated list of IP addresses that provide access to the cluster.
        format: Format of the output file. - Default: yaml

        ### Example:
        ```python
        ClustersApi(
            cluster_uuid='cluster_uuid_example',
                        cloud='cloud_example',
                        clusterip='clusterip_example',
                        format=yaml
        )
        ```
        """

        # Query params:
        query_params = [
            ("cloud", cloud),
            ("clusterip", clusterip),
            ("format", format),
        ]
        resource_path = f"/v1/k8s/clusters/{cluster_uuid}/installfile".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def update_cluster(
        self,
        cluster_uuid: str,
        cluster_update_request: models.ClusterUpdateRequest,
    ):
        r"""


        ### Description
        Update a cluster by id.

        ### Parameters:
        ```python
        cluster_uuid: str
        cluster_update_request: ClusterUpdateRequest
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        cluster_update_request: The cluster details to update

        ### Example:
        ```python
        ClustersApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        cluster_update_request=runai.ClusterUpdateRequest()
        )
        ```
        """

        # Body params:
        body_params = cluster_update_request

        resource_path = f"/api/v1/clusters/{cluster_uuid}".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
