from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class CredentialsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_access_key(
        self,
        access_key_creation_request: models.AccessKeyCreationRequest,
    ):
        r"""


        ### Description
        Create an access key.

        ### Parameters:
        ```python
        access_key_creation_request: AccessKeyCreationRequest
        ```
        access_key_creation_request: See model AccessKeyCreationRequest for more information.

        ### Example:
        ```python
        CredentialsApi(
            access_key_creation_request=runai.AccessKeyCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = access_key_creation_request

        resource_path = f"/api/v1/asset/credentials/access_key".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def create_docker_registry(
        self,
        docker_registry_creation_request: models.DockerRegistryCreationRequest,
    ):
        r"""


        ### Description
        Create a docker registry credential.

        ### Parameters:
        ```python
        docker_registry_creation_request: DockerRegistryCreationRequest
        ```
        docker_registry_creation_request: See model DockerRegistryCreationRequest for more information.

        ### Example:
        ```python
        CredentialsApi(
            docker_registry_creation_request=runai.DockerRegistryCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = docker_registry_creation_request

        resource_path = f"/api/v1/asset/credentials/docker_registry".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def create_generic_secret(
        self,
        generic_secret_creation_request: models.GenericSecretCreationRequest,
    ):
        r"""


        ### Description
        Create a generic-secret.

        ### Parameters:
        ```python
        generic_secret_creation_request: GenericSecretCreationRequest
        ```
        generic_secret_creation_request: See model GenericSecretCreationRequest for more information.

        ### Example:
        ```python
        CredentialsApi(
            generic_secret_creation_request=runai.GenericSecretCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = generic_secret_creation_request

        resource_path = f"/api/v1/asset/credentials/generic_secret".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def create_password(
        self,
        password_creation_request: models.PasswordCreationRequest,
    ):
        r"""


        ### Description
        Create a userid / password credential.

        ### Parameters:
        ```python
        password_creation_request: PasswordCreationRequest
        ```
        password_creation_request: See model PasswordCreationRequest for more information.

        ### Example:
        ```python
        CredentialsApi(
            password_creation_request=runai.PasswordCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = password_creation_request

        resource_path = f"/api/v1/asset/credentials/password".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_access_key(
        self,
        asset_id: str,
    ):
        r"""


        ### Description
        Delete an access key.

        ### Parameters:
        ```python
        asset_id: str
        ```
        asset_id: Unique identifier of the asset.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/asset/credentials/access_key/{asset_id}".replace(
            "_", "-"
        )
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def delete_docker_registry(
        self,
        asset_id: str,
    ):
        r"""


        ### Description
        Delete a docker registry credential.

        ### Parameters:
        ```python
        asset_id: str
        ```
        asset_id: Unique identifier of the asset.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/asset/credentials/docker_registry/{asset_id}".replace(
            "_", "-"
        )
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def delete_generic_secret(
        self,
        asset_id: str,
    ):
        r"""


        ### Description
        Delete a generic-secret.

        ### Parameters:
        ```python
        asset_id: str
        ```
        asset_id: Unique identifier of the asset.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/asset/credentials/generic_secret/{asset_id}".replace(
            "_", "-"
        )
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def delete_password(
        self,
        asset_id: str,
    ):
        r"""


        ### Description
        Delete a password asset.

        ### Parameters:
        ```python
        asset_id: str
        ```
        asset_id: Unique identifier of the asset.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/asset/credentials/password/{asset_id}".replace(
            "_", "-"
        )
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_access_key_by_id(
        self,
        asset_id: str,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        Get an access key.

        ### Parameters:
        ```python
        asset_id: str
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        asset_id: Unique identifier of the asset.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials/access_key/{asset_id}".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_docker_registry_by_id(
        self,
        asset_id: str,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        Get a docker registry credential.

        ### Parameters:
        ```python
        asset_id: str
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        asset_id: Unique identifier of the asset.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials/docker_registry/{asset_id}".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_generic_secret_by_id(
        self,
        asset_id: str,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        Get a generic-secret.

        ### Parameters:
        ```python
        asset_id: str
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        asset_id: Unique identifier of the asset.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials/generic_secret/{asset_id}".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_password_by_id(
        self,
        asset_id: str,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        Get a userid / password credential.

        ### Parameters:
        ```python
        asset_id: str
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        asset_id: Unique identifier of the asset.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials/password/{asset_id}".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def list_access_keys(
        self,
        name: Optional[str] = None,
        scope: Optional[str] = None,
        project_id: Optional[int] = None,
        department_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        List access keys.

        ### Parameters:
        ```python
        name: Optional[str]
        scope: Optional[str]
        project_id: Optional[int]
        department_id: Optional[str]
        cluster_id: Optional[str]
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        name: Filter results by name.
        scope: Filter results by scope.
        project_id: Filter results by project id. If scope filter is project, only assets from the specific project will be included in the response. Otherwise, the response will include project, department, cluster, tenant and system assets.
        department_id: Filter results by department id. If scope filter is department, only assets from the specific department will be included in the response. Otherwise, the response will include department, cluster, tenant and system assets.
        cluster_id: Filter results by Universally Unique Identifier (UUID) of the cluster. If scope filter is cluster, only assets from the specific cluster will be included in the response. Otherwise, the response will include cluster, tenant and system assets.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            name='name_example',
                        scope='scope_example',
                        project_id=56,
                        department_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("name", name),
            ("scope", scope),
            ("projectId", project_id),
            ("departmentId", department_id),
            ("clusterId", cluster_id),
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials/access_key".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def list_credentials_assets(
        self,
        name: Optional[str] = None,
        scope: Optional[str] = None,
        project_id: Optional[int] = None,
        department_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        List credentials.

        ### Parameters:
        ```python
        name: Optional[str]
        scope: Optional[str]
        project_id: Optional[int]
        department_id: Optional[str]
        cluster_id: Optional[str]
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        name: Filter results by name.
        scope: Filter results by scope.
        project_id: Filter results by project id. If scope filter is project, only assets from the specific project will be included in the response. Otherwise, the response will include project, department, cluster, tenant and system assets.
        department_id: Filter results by department id. If scope filter is department, only assets from the specific department will be included in the response. Otherwise, the response will include department, cluster, tenant and system assets.
        cluster_id: Filter results by Universally Unique Identifier (UUID) of the cluster. If scope filter is cluster, only assets from the specific cluster will be included in the response. Otherwise, the response will include cluster, tenant and system assets.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            name='name_example',
                        scope='scope_example',
                        project_id=56,
                        department_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("name", name),
            ("scope", scope),
            ("projectId", project_id),
            ("departmentId", department_id),
            ("clusterId", cluster_id),
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def list_docker_registries(
        self,
        name: Optional[str] = None,
        scope: Optional[str] = None,
        project_id: Optional[int] = None,
        department_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        List docker registry credentials.

        ### Parameters:
        ```python
        name: Optional[str]
        scope: Optional[str]
        project_id: Optional[int]
        department_id: Optional[str]
        cluster_id: Optional[str]
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        name: Filter results by name.
        scope: Filter results by scope.
        project_id: Filter results by project id. If scope filter is project, only assets from the specific project will be included in the response. Otherwise, the response will include project, department, cluster, tenant and system assets.
        department_id: Filter results by department id. If scope filter is department, only assets from the specific department will be included in the response. Otherwise, the response will include department, cluster, tenant and system assets.
        cluster_id: Filter results by Universally Unique Identifier (UUID) of the cluster. If scope filter is cluster, only assets from the specific cluster will be included in the response. Otherwise, the response will include cluster, tenant and system assets.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            name='name_example',
                        scope='scope_example',
                        project_id=56,
                        department_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("name", name),
            ("scope", scope),
            ("projectId", project_id),
            ("departmentId", department_id),
            ("clusterId", cluster_id),
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials/docker_registry".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def list_generic_secret(
        self,
        name: Optional[str] = None,
        scope: Optional[str] = None,
        project_id: Optional[int] = None,
        department_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        List generic-secrets.

        ### Parameters:
        ```python
        name: Optional[str]
        scope: Optional[str]
        project_id: Optional[int]
        department_id: Optional[str]
        cluster_id: Optional[str]
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        name: Filter results by name.
        scope: Filter results by scope.
        project_id: Filter results by project id. If scope filter is project, only assets from the specific project will be included in the response. Otherwise, the response will include project, department, cluster, tenant and system assets.
        department_id: Filter results by department id. If scope filter is department, only assets from the specific department will be included in the response. Otherwise, the response will include department, cluster, tenant and system assets.
        cluster_id: Filter results by Universally Unique Identifier (UUID) of the cluster. If scope filter is cluster, only assets from the specific cluster will be included in the response. Otherwise, the response will include cluster, tenant and system assets.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            name='name_example',
                        scope='scope_example',
                        project_id=56,
                        department_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("name", name),
            ("scope", scope),
            ("projectId", project_id),
            ("departmentId", department_id),
            ("clusterId", cluster_id),
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials/generic_secret".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def list_passwords(
        self,
        name: Optional[str] = None,
        scope: Optional[str] = None,
        project_id: Optional[int] = None,
        department_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        usage_info: Optional[bool] = None,
        status_info: Optional[bool] = None,
    ):
        r"""


        ### Description
        List password credentials.

        ### Parameters:
        ```python
        name: Optional[str]
        scope: Optional[str]
        project_id: Optional[int]
        department_id: Optional[str]
        cluster_id: Optional[str]
        usage_info: Optional[bool]
        status_info: Optional[bool]
        ```
        name: Filter results by name.
        scope: Filter results by scope.
        project_id: Filter results by project id. If scope filter is project, only assets from the specific project will be included in the response. Otherwise, the response will include project, department, cluster, tenant and system assets.
        department_id: Filter results by department id. If scope filter is department, only assets from the specific department will be included in the response. Otherwise, the response will include department, cluster, tenant and system assets.
        cluster_id: Filter results by Universally Unique Identifier (UUID) of the cluster. If scope filter is cluster, only assets from the specific cluster will be included in the response. Otherwise, the response will include cluster, tenant and system assets.
        usage_info: Whether the query should include asset usage information as part of the response.
        status_info: Whether the query should include asset status information as part of the response.

        ### Example:
        ```python
        CredentialsApi(
            name='name_example',
                        scope='scope_example',
                        project_id=56,
                        department_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        usage_info=True,
                        status_info=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("name", name),
            ("scope", scope),
            ("projectId", project_id),
            ("departmentId", department_id),
            ("clusterId", cluster_id),
            ("usageInfo", usage_info),
            ("statusInfo", status_info),
        ]
        resource_path = f"/api/v1/asset/credentials/password".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def update_access_key(
        self,
        asset_id: str,
        access_key_update_request: models.AccessKeyUpdateRequest,
    ):
        r"""


        ### Description
        Update an access key.

        ### Parameters:
        ```python
        asset_id: str
        access_key_update_request: AccessKeyUpdateRequest
        ```
        asset_id: Unique identifier of the asset.
        access_key_update_request: See model AccessKeyUpdateRequest for more information.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example',
                        access_key_update_request=runai.AccessKeyUpdateRequest()
        )
        ```
        """

        # Body params:
        body_params = access_key_update_request

        resource_path = f"/api/v1/asset/credentials/access_key/{asset_id}".replace(
            "_", "-"
        )
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def update_docker_registry(
        self,
        asset_id: str,
        docker_registry_update_request: models.DockerRegistryUpdateRequest,
    ):
        r"""


        ### Description
        Update a docker registry credential.

        ### Parameters:
        ```python
        asset_id: str
        docker_registry_update_request: DockerRegistryUpdateRequest
        ```
        asset_id: Unique identifier of the asset.
        docker_registry_update_request: See model DockerRegistryUpdateRequest for more information.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example',
                        docker_registry_update_request=runai.DockerRegistryUpdateRequest()
        )
        ```
        """

        # Body params:
        body_params = docker_registry_update_request

        resource_path = f"/api/v1/asset/credentials/docker_registry/{asset_id}".replace(
            "_", "-"
        )
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def update_generic_secret(
        self,
        asset_id: str,
        generic_secret_update_request: models.GenericSecretUpdateRequest,
    ):
        r"""


        ### Description
        Update a generic-secret.

        ### Parameters:
        ```python
        asset_id: str
        generic_secret_update_request: GenericSecretUpdateRequest
        ```
        asset_id: Unique identifier of the asset.
        generic_secret_update_request: See model GenericSecretUpdateRequest for more information.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example',
                        generic_secret_update_request=runai.GenericSecretUpdateRequest()
        )
        ```
        """

        # Body params:
        body_params = generic_secret_update_request

        resource_path = f"/api/v1/asset/credentials/generic_secret/{asset_id}".replace(
            "_", "-"
        )
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def update_password(
        self,
        asset_id: str,
        password_update_request: models.PasswordUpdateRequest,
    ):
        r"""


        ### Description
        Update a password credential.

        ### Parameters:
        ```python
        asset_id: str
        password_update_request: PasswordUpdateRequest
        ```
        asset_id: Unique identifier of the asset.
        password_update_request: See model PasswordUpdateRequest for more information.

        ### Example:
        ```python
        CredentialsApi(
            asset_id='asset_id_example',
                        password_update_request=runai.PasswordUpdateRequest()
        )
        ```
        """

        # Body params:
        body_params = password_update_request

        resource_path = f"/api/v1/asset/credentials/password/{asset_id}".replace(
            "_", "-"
        )
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
