from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class DatasourcesApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def list_datasource_assets(
        self,
        name: Optional[str] = None,
        scope: Optional[str] = None,
        project_id: Optional[int] = None,
        department_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        usage_info: Optional[bool] = None,
        comply_to_project: Optional[int] = None,
        comply_to_workload_type: Optional[str] = None,
        status_info: Optional[bool] = None,
        asset_ids: Optional[str] = None,
        comply_to_replica_type: Optional[str] = None,
    ):
        r"""


        ### Description
        List datasource assets.

        ### Parameters:
        ```python
        name: Optional[str]
        scope: Optional[str]
        project_id: Optional[int]
        department_id: Optional[str]
        cluster_id: Optional[str]
        usage_info: Optional[bool]
        comply_to_project: Optional[int]
        comply_to_workload_type: Optional[str]
        status_info: Optional[bool]
        asset_ids: Optional[str]
        comply_to_replica_type: Optional[str]
        ```
        name: Filter results by name.
        scope: Filter results by scope.
        project_id: Filter results by project id. If scope filter is project, only assets from the specific project will be included in the response. Otherwise, the response will include project, department, cluster, tenant and system assets.
        department_id: Filter results by department id. If scope filter is department, only assets from the specific department will be included in the response. Otherwise, the response will include department, cluster, tenant and system assets.
        cluster_id: Filter results by Universally Unique Identifier (UUID) of the cluster. If scope filter is cluster, only assets from the specific cluster will be included in the response. Otherwise, the response will include cluster, tenant and system assets.
        usage_info: Whether the query should include asset usage information as part of the response.
        comply_to_project: Include workload creation compliance information of an asset, for a given project, as part of the response. To check compliance, you need to provide both project id and workload type.
        comply_to_workload_type: Include workload creation compliance information of an asset, for a given workload type, as part of the response. To check compliance, you need to provide both project id and workload type.
        status_info: Whether the query should include asset status information as part of the response.
        asset_ids: Filter results by the ids of the assets. Provided value should be a comma separated string of UUIDs.
        comply_to_replica_type: Include workload creation compliance information of an asset, for a given replica type, as part of the response. To check compliance, you need to provide both project id and workload type. For distributed, replica type should be provided as well.

        ### Example:
        ```python
        DatasourcesApi(
            name='name_example',
                        scope='scope_example',
                        project_id=56,
                        department_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        usage_info=True,
                        comply_to_project=56,
                        comply_to_workload_type='comply_to_workload_type_example',
                        status_info=True,
                        asset_ids='dbf4767e-2fa1-43b0-97a2-7c0cecda180b,550e8400-e29b-41d4-a716-44665544000a',
                        comply_to_replica_type='comply_to_replica_type_example'
        )
        ```
        """

        # Query params:
        query_params = [
            ("name", name),
            ("scope", scope),
            ("projectId", project_id),
            ("departmentId", department_id),
            ("clusterId", cluster_id),
            ("usageInfo", usage_info),
            ("complyToProject", comply_to_project),
            ("complyToWorkloadType", comply_to_workload_type),
            ("statusInfo", status_info),
            ("assetIds", asset_ids),
            ("complyToReplicaType", comply_to_replica_type),
        ]
        resource_path = f"/api/v1/asset/datasource".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )
