from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class DistributedApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_distributed(
        self,
        distributed_creation_request: Optional[
            models.DistributedCreationRequest
        ] = None,
    ):
        r"""


        ### Description
        Create a distributed training.

        ### Parameters:
        ```python
        distributed_creation_request: DistributedCreationRequest
        ```
        distributed_creation_request: See model DistributedCreationRequest for more information.

        ### Example:
        ```python
        DistributedApi(
            distributed_creation_request=runai.DistributedCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = distributed_creation_request

        resource_path = f"/api/v1/workloads/distributed".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_distributed(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Delete a distributed training by id.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        DistributedApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/distributed/{workload_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_distributed(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Get distributed training&#39;s data. [Experimental]

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        DistributedApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/distributed/{workload_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def resume_distributed(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Resume a distributed training.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        DistributedApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/distributed/{workload_id}/resume".replace(
            "_", "-"
        )
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def suspend_distributed(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Suspend a distributed training.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        DistributedApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/distributed/{workload_id}/suspend".replace(
            "_", "-"
        )
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
