from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class DistributedInferencesApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_distributed_inference(
        self,
        distributed_inference_creation_request: Optional[
            models.DistributedInferenceCreationRequest
        ] = None,
    ):
        r"""


        ### Description
        Create a distributed inference. [Experimental]

        ### Parameters:
        ```python
        distributed_inference_creation_request: DistributedInferenceCreationRequest
        ```
        distributed_inference_creation_request: See model DistributedInferenceCreationRequest for more information.

        ### Example:
        ```python
        DistributedInferencesApi(
            distributed_inference_creation_request=runai.DistributedInferenceCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = distributed_inference_creation_request

        resource_path = f"/api/v1/workloads/distributed_inferences".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_distributed_inference(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Delete a distributed inference. [Experimental]

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        DistributedInferencesApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = (
            f"/api/v1/workloads/distributed_inferences/{workload_id}".replace("_", "-")
        )
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_distributed_inference(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Get a distributed inference data. [Experimental]

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        DistributedInferencesApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = (
            f"/api/v1/workloads/distributed_inferences/{workload_id}".replace("_", "-")
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
