from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class IdpsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_idp(
        self,
        idp_creation_request: models.IdpCreationRequest,
    ):
        r"""


        ### Description
        Configure external idp

        ### Parameters:
        ```python
        idp_creation_request: IdpCreationRequest
        ```
        idp_creation_request: Idp configuration

        ### Example:
        ```python
        IdpsApi(
            idp_creation_request={"type":"saml","samlData":{"metadataXmlType":"url","metadataXmlUrl":"https://authhost/saml/metadata.xml"},"mappers":{"gid":"GID","groups":"GROUPS","supplementaryGroups":"SUPPLEMENTARYGROUPS","uid":"UID","email":"email"}}
        )
        ```
        """

        # Body params:
        body_params = idp_creation_request

        resource_path = f"/api/v1/idps".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_idp(
        self,
        idp: str,
    ):
        r"""


        ### Description
        Delete external idp by alias

        ### Parameters:
        ```python
        idp: str
        ```
        idp: The alias of the idp

        ### Example:
        ```python
        IdpsApi(
            idp='idp_example'
        )
        ```
        """

        resource_path = f"/api/v1/idps/{idp}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_idp(
        self,
        idp: str,
    ):
        r"""


        ### Description
        Get external idp by alias

        ### Parameters:
        ```python
        idp: str
        ```
        idp: The alias of the idp

        ### Example:
        ```python
        IdpsApi(
            idp='idp_example'
        )
        ```
        """

        resource_path = f"/api/v1/idps/{idp}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_idp_mappers(
        self,
        idp: str,
    ):
        r"""


        ### Description
        Get idp mappers

        ### Parameters:
        ```python
        idp: str
        ```
        idp: The alias of the idp

        ### Example:
        ```python
        IdpsApi(
            idp='idp_example'
        )
        ```
        """

        resource_path = f"/api/v1/idps/{idp}/mappers".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_idps(
        self,
    ):
        r"""


        ### Description
        Get external idps list

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        IdpsApi(

        )
        ```
        """

        resource_path = f"/api/v1/idps".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def update_idp(
        self,
        idp: str,
        idp_creation_request: models.IdpCreationRequest,
    ):
        r"""


        ### Description
        Update external idp by alias

        ### Parameters:
        ```python
        idp: str
        idp_creation_request: IdpCreationRequest
        ```
        idp: The alias of the idp
        idp_creation_request: Updated idp object

        ### Example:
        ```python
        IdpsApi(
            idp='idp_example',
                        idp_creation_request={"type":"saml","samlData":{"metadataXmlType":"url","metadataXmlUrl":"https://authhost/saml/metadata.xml"},"mappers":{"gid":"GID","groups":"GROUPS","supplementaryGroups":"SUPPLEMENTARYGROUPS","uid":"UID","email":"email"}}
        )
        ```
        """

        # Body params:
        body_params = idp_creation_request

        resource_path = f"/api/v1/idps/{idp}".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def update_idp_mappers(
        self,
        idp: str,
        mappers: models.Mappers,
    ):
        r"""


        ### Description
        Update idp mappers

        ### Parameters:
        ```python
        idp: str
        mappers: Mappers
        ```
        idp: The alias of the idp
        mappers: Map of our mappers and their source in the external idp

        ### Example:
        ```python
        IdpsApi(
            idp='idp_example',
                        mappers=runai.Mappers()
        )
        ```
        """

        # Body params:
        body_params = mappers

        resource_path = f"/api/v1/idps/{idp}/mappers".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
