from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class InferencesApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_inference1(
        self,
        inference_creation_request: Optional[models.InferenceCreationRequest] = None,
    ):
        r"""


        ### Description
        Create an inference.

        ### Parameters:
        ```python
        inference_creation_request: InferenceCreationRequest
        ```
        inference_creation_request: See model InferenceCreationRequest for more information.

        ### Example:
        ```python
        InferencesApi(
            inference_creation_request=runai.InferenceCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = inference_creation_request

        resource_path = f"/api/v1/workloads/inferences".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_inference(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Delete an inference.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        InferencesApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/inferences/{workload_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_inference(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Get inference data.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        InferencesApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/inferences/{workload_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_inference_workload_metrics(
        self,
        workload_id: str,
        metric_type: List[models.InferenceWorkloadMetricType],
        start: datetime,
        end: datetime,
        number_of_samples: Optional[int] = None,
    ):
        r"""


        ### Description
        Get inference metrics data.

        ### Parameters:
        ```python
        workload_id: str
        metric_type: Optional[models.List[InferenceWorkloadMetricType]]
        start: Optional[datetime]
        end: Optional[datetime]
        number_of_samples: Optional[int]
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.
        metric_type: Specify which data to request.
        start: Start date of time range to fetch data in ISO 8601 timestamp format.
        end: End date of time range to fetch data in ISO 8601 timestamp format.
        number_of_samples: The number of samples to take in the specified time range. - Default: 20

        ### Example:
        ```python
        InferencesApi(
            workload_id='workload_id_example',
                        metric_type=[runai.InferenceWorkloadMetricType()],
                        start='2023-06-06T12:09:18.211Z',
                        end='2023-06-07T12:09:18.211Z',
                        number_of_samples=20
        )
        ```
        """

        # Query params:
        query_params = [
            ("metricType", metric_type),
            ("start", start),
            ("end", end),
            ("numberOfSamples", number_of_samples),
        ]
        resource_path = f"/api/v1/workloads/inferences/{workload_id}/metrics".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_inference_workload_pod_metrics(
        self,
        workload_id: str,
        pod_id: str,
        metric_type: List[models.InferencePodMetricType],
        start: datetime,
        end: datetime,
        number_of_samples: Optional[int] = None,
    ):
        r"""


        ### Description
        Get inference pod&#39;s metrics data.

        ### Parameters:
        ```python
        workload_id: str
        pod_id: str
        metric_type: Optional[models.List[InferencePodMetricType]]
        start: Optional[datetime]
        end: Optional[datetime]
        number_of_samples: Optional[int]
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.
        pod_id: The requested pod id.
        metric_type: Specifies metrics data to request. Inference metrics are only available for inference workloads.
        start: Start date of time range to fetch data in ISO 8601 timestamp format.
        end: End date of time range to fetch data in ISO 8601 timestamp format.
        number_of_samples: The number of samples to take in the specified time range. - Default: 20

        ### Example:
        ```python
        InferencesApi(
            workload_id='workload_id_example',
                        pod_id='pod_id_example',
                        metric_type=[runai.InferencePodMetricType()],
                        start='2023-06-06T12:09:18.211Z',
                        end='2023-06-07T12:09:18.211Z',
                        number_of_samples=20
        )
        ```
        """

        # Query params:
        query_params = [
            ("metricType", metric_type),
            ("start", start),
            ("end", end),
            ("numberOfSamples", number_of_samples),
        ]
        resource_path = (
            f"/api/v1/workloads/inferences/{workload_id}/pods/{pod_id}/metrics".replace(
                "_", "-"
            )
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def update_inference_spec(
        self,
        workload_id: str,
        inference_update_request: Optional[models.InferenceUpdateRequest] = None,
    ):
        r"""


        ### Description
        Update inference spec. [Experimental]

        ### Parameters:
        ```python
        workload_id: str
        inference_update_request: InferenceUpdateRequest
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.
        inference_update_request: See model InferenceUpdateRequest for more information.

        ### Example:
        ```python
        InferencesApi(
            workload_id='workload_id_example',
                        inference_update_request=runai.InferenceUpdateRequest()
        )
        ```
        """

        # Body params:
        body_params = inference_update_request

        resource_path = f"/api/v1/workloads/inferences/{workload_id}".replace("_", "-")
        method = "PATCH"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
