from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class LogoApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def get_tenant_logo(
        self,
    ):
        r"""


        ### Description
        Get tenant logo. (base64)

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        LogoApi(

        )
        ```
        """

        resource_path = f"/api/v1/logo".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def upload_tenant_logo(
        self,
        logo_creation_request: Optional[models.LogoCreationRequest] = None,
    ):
        r"""


        ### Description
        Upload logo for tenant. (base64)

        ### Parameters:
        ```python
        logo_creation_request: LogoCreationRequest
        ```
        logo_creation_request: See model LogoCreationRequest for more information.

        ### Example:
        ```python
        LogoApi(
            logo_creation_request=runai.LogoCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = logo_creation_request

        resource_path = f"/api/v1/logo".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
