from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class NodePoolsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def count_nodepools(
        self,
        filter_by: Optional[List[str]] = None,
    ):
        r"""


        ### Description
        Count nodepools

        ### Parameters:
        ```python
        filter_by: Optional[List[str]]
        ```
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &#x3D;&#x3D; Equals, !&#x3D; Not equals, &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains, !@ Does not contains, &#x3D;^ Starts with and &#x3D;$ Ends with. Dates are in ISO 8601 timestamp format and available for operators &#x3D;&#x3D;, !&#x3D;, &lt;&#x3D; and &gt;&#x3D;.

        ### Example:
        ```python
        NodePoolsApi(
            filter_by=['[\"name!=some-name\"]']
        )
        ```
        """

        # Query params:
        query_params = [
            ("filterBy", filter_by),
        ]
        resource_path = f"/api/v1/node_pools/count".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    @deprecated_message()
    def create_node_pool(
        self,
        cluster_id: str,
        node_pool_create_request: Optional[models.NodePoolCreateRequest] = None,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Create a Node Pool.

        ### Parameters:
        ```python
        cluster_id: str
        node_pool_create_request: NodePoolCreateRequest
        ```
        cluster_id: Unique identifier of the cluster
        node_pool_create_request: See model NodePoolCreateRequest for more information.

        ### Example:
        ```python
        NodePoolsApi(
            cluster_id='cluster_id_example',
                        node_pool_create_request=runai.NodePoolCreateRequest()
        )
        ```
        """

        # Body params:
        body_params = node_pool_create_request

        resource_path = f"/v1/k8s/clusters/{cluster_id}/node_pools".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def create_nodepool(
        self,
        nodepool_create_fields: models.NodepoolCreateFields,
    ):
        r"""


        ### Description
        Create nodepool

        ### Parameters:
        ```python
        nodepool_create_fields: NodepoolCreateFields
        ```
        nodepool_create_fields: Nodepool to create.

        ### Example:
        ```python
        NodePoolsApi(
            nodepool_create_fields=runai.NodepoolCreateFields()
        )
        ```
        """

        # Body params:
        body_params = nodepool_create_fields

        resource_path = f"/api/v1/node_pools".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    @deprecated_message()
    def delete_node_pool(
        self,
        cluster_id: str,
        id: int,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Delete a Node Pool by id.§

        ### Parameters:
        ```python
        cluster_id: str
        id: int
        ```
        cluster_id: Unique identifier of the cluster
        id: The unique id identifying the Node Pool.

        ### Example:
        ```python
        NodePoolsApi(
            cluster_id='cluster_id_example',
                        id=56
        )
        ```
        """

        resource_path = f"/v1/k8s/clusters/{cluster_id}/node_pools/{id}".replace(
            "_", "-"
        )
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def delete_nodepool(
        self,
        nodepool_id: str,
    ):
        r"""


        ### Description
        Delete nodepool

        ### Parameters:
        ```python
        nodepool_id: str
        ```
        nodepool_id: The unique id identifying the Node Pool.

        ### Example:
        ```python
        NodePoolsApi(
            nodepool_id='17'
        )
        ```
        """

        resource_path = f"/api/v1/node_pools/{nodepool_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_node_pools(
        self,
        cluster_id: str,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get the cluster&#39;s Node Pools.

        ### Parameters:
        ```python
        cluster_id: str
        ```
        cluster_id: Unique identifier of the cluster

        ### Example:
        ```python
        NodePoolsApi(
            cluster_id='cluster_id_example'
        )
        ```
        """

        resource_path = f"/v1/k8s/clusters/{cluster_id}/node_pools".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_nodepool(
        self,
        nodepool_id: str,
    ):
        r"""


        ### Description
        Get nodepool

        ### Parameters:
        ```python
        nodepool_id: str
        ```
        nodepool_id: The unique id identifying the Node Pool.

        ### Example:
        ```python
        NodePoolsApi(
            nodepool_id='17'
        )
        ```
        """

        resource_path = f"/api/v1/node_pools/{nodepool_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_nodepool_metrics(
        self,
        cluster_uuid: str,
        nodepool_name: str,
        start: datetime,
        end: datetime,
        metric_type: List[models.MetricsType],
        number_of_samples: Optional[int] = None,
    ):
        r"""


        ### Description
        Get the node pool metrics data.

        ### Parameters:
        ```python
        cluster_uuid: str
        nodepool_name: str
        start: Optional[datetime]
        end: Optional[datetime]
        metric_type: Optional[models.List[MetricsType]]
        number_of_samples: Optional[int]
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        nodepool_name: The unique nodepool name.
        start: Start date of time range to fetch data in ISO 8601 timestamp format.
        end: End date of time range to fetch data in ISO 8601 timestamp format.
        metric_type: specifies what data to request
        number_of_samples: The number of samples to take in the specified time range. - Default: 20

        ### Example:
        ```python
        NodePoolsApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        nodepool_name='default',
                        start='2023-06-06T12:09:18.211Z',
                        end='2023-06-07T12:09:18.211Z',
                        metric_type=[runai.MetricsType()],
                        number_of_samples=20
        )
        ```
        """

        # Query params:
        query_params = [
            ("start", start),
            ("end", end),
            ("numberOfSamples", number_of_samples),
            ("metricType", metric_type),
        ]
        resource_path = f"/api/v1/clusters/{cluster_uuid}/nodepools/{nodepool_name}/metrics".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_nodepools(
        self,
        filter_by: Optional[List[str]] = None,
        sort_by: Optional[models.NodepoolSortFilterFields] = None,
        sort_order: Optional[str] = None,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
    ):
        r"""


        ### Description
        Get nodepools

        ### Parameters:
        ```python
        filter_by: Optional[List[str]]
        sort_by: Optional[models.NodepoolSortFilterFields]
        sort_order: Optional[str]
        offset: Optional[int]
        limit: Optional[int]
        ```
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &#x3D;&#x3D; Equals, !&#x3D; Not equals, &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains, !@ Does not contains, &#x3D;^ Starts with and &#x3D;$ Ends with. Dates are in ISO 8601 timestamp format and available for operators &#x3D;&#x3D;, !&#x3D;, &lt;&#x3D; and &gt;&#x3D;.
        sort_by: Sort results by a parameters.
        sort_order: Sort results in descending or ascending order. - Default: asc
        offset: The offset of the first item returned in the collection.
        limit: The maximum number of entries to return. - Default: 50

        ### Example:
        ```python
        NodePoolsApi(
            filter_by=['[\"name!=some-name\"]'],
                        sort_by=runai.NodepoolSortFilterFields(),
                        sort_order=asc,
                        offset=100,
                        limit=50
        )
        ```
        """

        # Query params:
        query_params = [
            ("filterBy", filter_by),
            ("sortBy", sort_by),
            ("sortOrder", sort_order),
            ("offset", offset),
            ("limit", limit),
        ]
        resource_path = f"/api/v1/node_pools".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def patch_nodepool(
        self,
        nodepool_id: str,
        nodepool_update_fields: models.NodepoolUpdateFields,
    ):
        r"""


        ### Description
        Patch nodepool fields

        ### Parameters:
        ```python
        nodepool_id: str
        nodepool_update_fields: NodepoolUpdateFields
        ```
        nodepool_id: The unique id identifying the Node Pool.
        nodepool_update_fields: Fields to update.

        ### Example:
        ```python
        NodePoolsApi(
            nodepool_id='17',
                        nodepool_update_fields=runai.NodepoolUpdateFields()
        )
        ```
        """

        # Body params:
        body_params = nodepool_update_fields

        resource_path = f"/api/v1/node_pools/{nodepool_id}".replace("_", "-")
        method = "PATCH"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    @deprecated_message()
    def update_node_pool(
        self,
        cluster_id: str,
        id: int,
        update_node_pool_request: models.UpdateNodePoolRequest,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Update a Node Pool.

        ### Parameters:
        ```python
        cluster_id: str
        id: int
        update_node_pool_request: UpdateNodePoolRequest
        ```
        cluster_id: Unique identifier of the cluster
        id: The unique id identifying the Node Pool.
        update_node_pool_request: See model UpdateNodePoolRequest for more information.

        ### Example:
        ```python
        NodePoolsApi(
            cluster_id='cluster_id_example',
                        id=56,
                        update_node_pool_request=runai.UpdateNodePoolRequest()
        )
        ```
        """

        # Body params:
        body_params = update_node_pool_request

        resource_path = f"/v1/k8s/clusters/{cluster_id}/node_pools/{id}".replace(
            "_", "-"
        )
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    @deprecated_message()
    def update_node_pool_labels(
        self,
        cluster_id: str,
        id: int,
        node_pool_labels_request: models.NodePoolLabelsRequest,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Update labels of a Node Pool.

        ### Parameters:
        ```python
        cluster_id: str
        id: int
        node_pool_labels_request: NodePoolLabelsRequest
        ```
        cluster_id: Unique identifier of the cluster
        id: The unique id identifying the Node Pool.
        node_pool_labels_request: See model NodePoolLabelsRequest for more information.

        ### Example:
        ```python
        NodePoolsApi(
            cluster_id='cluster_id_example',
                        id=56,
                        node_pool_labels_request=runai.NodePoolLabelsRequest()
        )
        ```
        """

        # Body params:
        body_params = node_pool_labels_request

        resource_path = f"/v1/k8s/clusters/{cluster_id}/node_pools/{id}/labels".replace(
            "_", "-"
        )
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def update_nodepool(
        self,
        nodepool_id: str,
        nodepool_update_fields: models.NodepoolUpdateFields,
    ):
        r"""


        ### Description
        Update nodepool

        ### Parameters:
        ```python
        nodepool_id: str
        nodepool_update_fields: NodepoolUpdateFields
        ```
        nodepool_id: The unique id identifying the Node Pool.
        nodepool_update_fields: Nodepool to update.

        ### Example:
        ```python
        NodePoolsApi(
            nodepool_id='17',
                        nodepool_update_fields=runai.NodepoolUpdateFields()
        )
        ```
        """

        # Body params:
        body_params = nodepool_update_fields

        resource_path = f"/api/v1/node_pools/{nodepool_id}".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
