from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class NodesApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def count_nodes(
        self,
        cluster_uuid: str,
        filter_by: Optional[List[str]] = None,
        search: Optional[str] = None,
    ):
        r"""


        ### Description
        Count nodes

        ### Parameters:
        ```python
        cluster_uuid: str
        filter_by: Optional[List[str]]
        search: Optional[str]
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &#x3D;&#x3D; Equals, !&#x3D; Not equals, &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains, !@ Does not contains, &#x3D;^ Starts with and &#x3D;$ Ends with. Dates are in ISO 8601 timestamp format and available for operators &#x3D;&#x3D;, !&#x3D;, &lt;&#x3D; and &gt;&#x3D;.
        search: Filter results by a free text search.

        ### Example:
        ```python
        NodesApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        filter_by=['[\"name!=some-name\"]'],
                        search='test project'
        )
        ```
        """

        # Query params:
        query_params = [
            ("filterBy", filter_by),
            ("search", search),
        ]
        resource_path = f"/api/v1/clusters/{cluster_uuid}/nodes/count".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_node_metrics(
        self,
        node_id: str,
        metric_type: List[models.NodeMetricType],
        start: datetime,
        end: datetime,
        number_of_samples: Optional[int] = None,
    ):
        r"""


        ### Description
        Get the node metrics data.

        ### Parameters:
        ```python
        node_id: str
        metric_type: Optional[models.List[NodeMetricType]]
        start: Optional[datetime]
        end: Optional[datetime]
        number_of_samples: Optional[int]
        ```
        node_id: The node UUID.
        metric_type: Specify which data to request.
        start: Start date of time range to fetch data in ISO 8601 timestamp format.
        end: End date of time range to fetch data in ISO 8601 timestamp format.
        number_of_samples: The number of samples to take in the specified time range. - Default: 20

        ### Example:
        ```python
        NodesApi(
            node_id='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        metric_type=[runai.NodeMetricType()],
                        start='2023-06-06T12:09:18.211Z',
                        end='2023-06-07T12:09:18.211Z',
                        number_of_samples=20
        )
        ```
        """

        # Query params:
        query_params = [
            ("metricType", metric_type),
            ("start", start),
            ("end", end),
            ("numberOfSamples", number_of_samples),
        ]
        resource_path = f"/api/v1/nodes/{node_id}/metrics".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_node_telemetry(
        self,
        telemetry_type: models.NodeTelemetryType,
        cluster_id: Optional[str] = None,
        nodepool_name: Optional[str] = None,
        group_by: Optional[List[str]] = None,
    ):
        r"""


        ### Description
        Get node telemetry data.

        ### Parameters:
        ```python
        telemetry_type: Optional[models.NodeTelemetryType]
        cluster_id: Optional[str]
        nodepool_name: Optional[str]
        group_by: Optional[List[str]]
        ```
        telemetry_type: specifies what data to request
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.
        nodepool_name: Filter using the nodepool.
        group_by: workload fields to group the data by

        ### Example:
        ```python
        NodesApi(
            telemetry_type=runai.NodeTelemetryType(),
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        nodepool_name='default',
                        group_by=['group_by_example']
        )
        ```
        """

        # Query params:
        query_params = [
            ("clusterId", cluster_id),
            ("nodepoolName", nodepool_name),
            ("groupBy", group_by),
            ("telemetryType", telemetry_type),
        ]
        resource_path = f"/api/v1/nodes/telemetry".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_nodes(
        self,
        cluster_uuid: str,
        node_name: Optional[str] = None,
        filter_by: Optional[List[str]] = None,
        sort_by: Optional[models.NodeFilterSortFields] = None,
        sort_order: Optional[str] = None,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        search: Optional[str] = None,
    ):
        r"""


        ### Description
        Get a list of nodes.

        ### Parameters:
        ```python
        cluster_uuid: str
        node_name: Optional[str]
        filter_by: Optional[List[str]]
        sort_by: Optional[models.NodeFilterSortFields]
        sort_order: Optional[str]
        offset: Optional[int]
        limit: Optional[int]
        search: Optional[str]
        ```
        cluster_uuid: The Universally Unique Identifier (UUID) of the cluster.
        node_name: Deprecated - use filterBy instead. The node name; Cannot be used together with filterBy, sort, offset, limit or search query params.
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &#x3D;&#x3D; Equals, !&#x3D; Not equals, &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains, !@ Does not contains, &#x3D;^ Starts with and &#x3D;$ Ends with. Dates are in ISO 8601 timestamp format and available for operators &#x3D;&#x3D;, !&#x3D;, &lt;&#x3D; and &gt;&#x3D;.
        sort_by: Sort results by a parameters.
        sort_order: Sort results in descending or ascending order. - Default: asc
        offset: The offset of the first item returned in the collection.
        limit: The maximum number of entries to return. - Default: 50
        search: Filter results by a free text search.

        ### Example:
        ```python
        NodesApi(
            cluster_uuid='9f55255e-11ed-47c7-acef-fc4054768dbc',
                        node_name='node_name_example',
                        filter_by=['[\"name!=some-name\"]'],
                        sort_by=runai.NodeFilterSortFields(),
                        sort_order=asc,
                        offset=100,
                        limit=50,
                        search='test project'
        )
        ```
        """

        # Query params:
        query_params = [
            ("nodeName", node_name),
            ("filterBy", filter_by),
            ("sortBy", sort_by),
            ("sortOrder", sort_order),
            ("offset", offset),
            ("limit", limit),
            ("search", search),
        ]
        resource_path = f"/api/v1/clusters/{cluster_uuid}/nodes".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )
