from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class PermissionsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def get_permissions(
        self,
    ):
        r"""


        ### Description
        Get a summary of user permissions.

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        PermissionsApi(

        )
        ```
        """

        resource_path = f"/api/v1/authorization/permissions".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_permitted_scopes(
        self,
        get_permitted_scopes_request: models.GetPermittedScopesRequest,
    ):
        r"""


        ### Description
        Calculate permitted scopes.

        ### Parameters:
        ```python
        get_permitted_scopes_request: GetPermittedScopesRequest
        ```
        get_permitted_scopes_request: The request parameters.

        ### Example:
        ```python
        PermissionsApi(
            get_permitted_scopes_request=runai.GetPermittedScopesRequest()
        )
        ```
        """

        # Body params:
        body_params = get_permitted_scopes_request

        resource_path = f"/api/v1/authorization/permitted_scopes".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
