from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class PolicyApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def delete_distributed_policy(
        self,
        scope: str,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
    ):
        r"""


        ### Description
        Delete a distributed policy.

        ### Parameters:
        ```python
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        ```
        scope: The scope that the policy relates to.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.

        ### Example:
        ```python
        PolicyApi(
            scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128'
        )
        ```
        """

        # Query params:
        query_params = [
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
        ]
        resource_path = f"/api/v2/policy/distributed".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def delete_inference_policy(
        self,
        scope: str,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
    ):
        r"""


        ### Description
        Delete an inference policy.

        ### Parameters:
        ```python
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        ```
        scope: The scope that the policy relates to.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.

        ### Example:
        ```python
        PolicyApi(
            scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128'
        )
        ```
        """

        # Query params:
        query_params = [
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
        ]
        resource_path = f"/api/v2/policy/inferences".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def delete_training_policy(
        self,
        scope: str,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
    ):
        r"""


        ### Description
        Delete a training policy.

        ### Parameters:
        ```python
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        ```
        scope: The scope that the policy relates to.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.

        ### Example:
        ```python
        PolicyApi(
            scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128'
        )
        ```
        """

        # Query params:
        query_params = [
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
        ]
        resource_path = f"/api/v2/policy/trainings".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def delete_workspace_policy(
        self,
        scope: str,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
    ):
        r"""


        ### Description
        Delete a workspace policy.

        ### Parameters:
        ```python
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        ```
        scope: The scope that the policy relates to.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.

        ### Example:
        ```python
        PolicyApi(
            scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128'
        )
        ```
        """

        # Query params:
        query_params = [
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
        ]
        resource_path = f"/api/v2/policy/workspaces".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_distributed_policy_v2(
        self,
        scope: str,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
    ):
        r"""


        ### Description
        Get a distributed policy.

        ### Parameters:
        ```python
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        ```
        scope: The scope that the policy relates to.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.

        ### Example:
        ```python
        PolicyApi(
            scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128'
        )
        ```
        """

        # Query params:
        query_params = [
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
        ]
        resource_path = f"/api/v2/policy/distributed".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_inference_policy_v2(
        self,
        scope: str,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
    ):
        r"""


        ### Description
        Get an inference policy.

        ### Parameters:
        ```python
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        ```
        scope: The scope that the policy relates to.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.

        ### Example:
        ```python
        PolicyApi(
            scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128'
        )
        ```
        """

        # Query params:
        query_params = [
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
        ]
        resource_path = f"/api/v2/policy/inferences".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_training_policy_v2(
        self,
        scope: str,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
    ):
        r"""


        ### Description
        Get a training policy.

        ### Parameters:
        ```python
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        ```
        scope: The scope that the policy relates to.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.

        ### Example:
        ```python
        PolicyApi(
            scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128'
        )
        ```
        """

        # Query params:
        query_params = [
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
        ]
        resource_path = f"/api/v2/policy/trainings".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_workspace_policy_v2(
        self,
        scope: str,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
    ):
        r"""


        ### Description
        Get a workspace policy.

        ### Parameters:
        ```python
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        ```
        scope: The scope that the policy relates to.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.

        ### Example:
        ```python
        PolicyApi(
            scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128'
        )
        ```
        """

        # Query params:
        query_params = [
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
        ]
        resource_path = f"/api/v2/policy/workspaces".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def list_policies(
        self,
        workload_type: Optional[str] = None,
        scope: Optional[str] = None,
        department_id: Optional[str] = None,
        project_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        include_fallback_policies: Optional[bool] = None,
    ):
        r"""


        ### Description
        List policies

        ### Parameters:
        ```python
        workload_type: Optional[str]
        scope: Optional[str]
        department_id: Optional[str]
        project_id: Optional[str]
        cluster_id: Optional[str]
        include_fallback_policies: Optional[bool]
        ```
        workload_type: Policy for a specific workload type.
        scope: filter by this scope.
        department_id: Filter using the department id.
        project_id: project id to filter by
        cluster_id: Filter using the Universally Unique Identifier (UUID) of the cluster.
        include_fallback_policies: whether to include fallback policies in the list. Default to false.

        ### Example:
        ```python
        PolicyApi(
            workload_type='workload_type_example',
                        scope='scope_example',
                        department_id='1',
                        project_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        include_fallback_policies=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("workloadType", workload_type),
            ("scope", scope),
            ("departmentId", department_id),
            ("projectId", project_id),
            ("clusterId", cluster_id),
            ("includeFallbackPolicies", include_fallback_policies),
        ]
        resource_path = f"/api/v2/policy".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def overwrite_distributed_policy_v2(
        self,
        validate_only: Optional[bool] = None,
        distributed_policy_overwrite_request_v2: Optional[
            models.DistributedPolicyOverwriteRequestV2
        ] = None,
    ):
        r"""


        ### Description
        Overwrite a distributed policy.

        ### Parameters:
        ```python
        validate_only: Optional[bool]
        distributed_policy_overwrite_request_v2: DistributedPolicyOverwriteRequestV2
        ```
        validate_only: Validate the given policy payload without applying it
        distributed_policy_overwrite_request_v2: See model DistributedPolicyOverwriteRequestV2 for more information.

        ### Example:
        ```python
        PolicyApi(
            validate_only=True,
                        distributed_policy_overwrite_request_v2=runai.DistributedPolicyOverwriteRequestV2()
        )
        ```
        """

        # Body params:
        body_params = distributed_policy_overwrite_request_v2

        # Query params:
        query_params = [
            ("validateOnly", validate_only),
        ]
        resource_path = f"/api/v2/policy/distributed".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
            query_params=query_params,
        )

    def overwrite_inference_policy_v2(
        self,
        validate_only: Optional[bool] = None,
        inference_policy_overwrite_request_v2: Optional[
            models.InferencePolicyOverwriteRequestV2
        ] = None,
    ):
        r"""


        ### Description
        Overwrite an inference policy.

        ### Parameters:
        ```python
        validate_only: Optional[bool]
        inference_policy_overwrite_request_v2: InferencePolicyOverwriteRequestV2
        ```
        validate_only: Validate the given policy payload without applying it
        inference_policy_overwrite_request_v2: See model InferencePolicyOverwriteRequestV2 for more information.

        ### Example:
        ```python
        PolicyApi(
            validate_only=True,
                        inference_policy_overwrite_request_v2=runai.InferencePolicyOverwriteRequestV2()
        )
        ```
        """

        # Body params:
        body_params = inference_policy_overwrite_request_v2

        # Query params:
        query_params = [
            ("validateOnly", validate_only),
        ]
        resource_path = f"/api/v2/policy/inferences".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
            query_params=query_params,
        )

    def overwrite_training_policy_v2(
        self,
        validate_only: Optional[bool] = None,
        training_policy_overwrite_request_v2: Optional[
            models.TrainingPolicyOverwriteRequestV2
        ] = None,
    ):
        r"""


        ### Description
        Overwrite a training policy.

        ### Parameters:
        ```python
        validate_only: Optional[bool]
        training_policy_overwrite_request_v2: TrainingPolicyOverwriteRequestV2
        ```
        validate_only: Validate the given policy payload without applying it
        training_policy_overwrite_request_v2: See model TrainingPolicyOverwriteRequestV2 for more information.

        ### Example:
        ```python
        PolicyApi(
            validate_only=True,
                        training_policy_overwrite_request_v2=runai.TrainingPolicyOverwriteRequestV2()
        )
        ```
        """

        # Body params:
        body_params = training_policy_overwrite_request_v2

        # Query params:
        query_params = [
            ("validateOnly", validate_only),
        ]
        resource_path = f"/api/v2/policy/trainings".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
            query_params=query_params,
        )

    def overwrite_workspace_policy_v2(
        self,
        validate_only: Optional[bool] = None,
        workspace_policy_overwrite_request_v2: Optional[
            models.WorkspacePolicyOverwriteRequestV2
        ] = None,
    ):
        r"""


        ### Description
        Overwrite a workspace policy.

        ### Parameters:
        ```python
        validate_only: Optional[bool]
        workspace_policy_overwrite_request_v2: WorkspacePolicyOverwriteRequestV2
        ```
        validate_only: Validate the given policy payload without applying it
        workspace_policy_overwrite_request_v2: See model WorkspacePolicyOverwriteRequestV2 for more information.

        ### Example:
        ```python
        PolicyApi(
            validate_only=True,
                        workspace_policy_overwrite_request_v2=runai.WorkspacePolicyOverwriteRequestV2()
        )
        ```
        """

        # Body params:
        body_params = workspace_policy_overwrite_request_v2

        # Query params:
        query_params = [
            ("validateOnly", validate_only),
        ]
        resource_path = f"/api/v2/policy/workspaces".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
            query_params=query_params,
        )

    def update_distributed_policy_v2(
        self,
        validate_only: Optional[bool] = None,
        distributed_policy_change_request_v2: Optional[
            models.DistributedPolicyChangeRequestV2
        ] = None,
    ):
        r"""


        ### Description
        Update a distributed policy.

        ### Parameters:
        ```python
        validate_only: Optional[bool]
        distributed_policy_change_request_v2: DistributedPolicyChangeRequestV2
        ```
        validate_only: Validate the given policy payload without applying it
        distributed_policy_change_request_v2: See model DistributedPolicyChangeRequestV2 for more information.

        ### Example:
        ```python
        PolicyApi(
            validate_only=True,
                        distributed_policy_change_request_v2=runai.DistributedPolicyChangeRequestV2()
        )
        ```
        """

        # Body params:
        body_params = distributed_policy_change_request_v2

        # Query params:
        query_params = [
            ("validateOnly", validate_only),
        ]
        resource_path = f"/api/v2/policy/distributed".replace("_", "-")
        method = "PATCH"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
            query_params=query_params,
        )

    def update_inference_policy_v2(
        self,
        validate_only: Optional[bool] = None,
        inference_policy_change_request_v2: Optional[
            models.InferencePolicyChangeRequestV2
        ] = None,
    ):
        r"""


        ### Description
        Update an inference policy.

        ### Parameters:
        ```python
        validate_only: Optional[bool]
        inference_policy_change_request_v2: InferencePolicyChangeRequestV2
        ```
        validate_only: Validate the given policy payload without applying it
        inference_policy_change_request_v2: See model InferencePolicyChangeRequestV2 for more information.

        ### Example:
        ```python
        PolicyApi(
            validate_only=True,
                        inference_policy_change_request_v2=runai.InferencePolicyChangeRequestV2()
        )
        ```
        """

        # Body params:
        body_params = inference_policy_change_request_v2

        # Query params:
        query_params = [
            ("validateOnly", validate_only),
        ]
        resource_path = f"/api/v2/policy/inferences".replace("_", "-")
        method = "PATCH"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
            query_params=query_params,
        )

    def update_training_policy_v2(
        self,
        validate_only: Optional[bool] = None,
        training_policy_change_request_v2: Optional[
            models.TrainingPolicyChangeRequestV2
        ] = None,
    ):
        r"""


        ### Description
        Update a training policy.

        ### Parameters:
        ```python
        validate_only: Optional[bool]
        training_policy_change_request_v2: TrainingPolicyChangeRequestV2
        ```
        validate_only: Validate the given policy payload without applying it
        training_policy_change_request_v2: See model TrainingPolicyChangeRequestV2 for more information.

        ### Example:
        ```python
        PolicyApi(
            validate_only=True,
                        training_policy_change_request_v2=runai.TrainingPolicyChangeRequestV2()
        )
        ```
        """

        # Body params:
        body_params = training_policy_change_request_v2

        # Query params:
        query_params = [
            ("validateOnly", validate_only),
        ]
        resource_path = f"/api/v2/policy/trainings".replace("_", "-")
        method = "PATCH"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
            query_params=query_params,
        )

    def update_workspace_policy_v2(
        self,
        validate_only: Optional[bool] = None,
        workspace_policy_change_request_v2: Optional[
            models.WorkspacePolicyChangeRequestV2
        ] = None,
    ):
        r"""


        ### Description
        Update a workspace policy.

        ### Parameters:
        ```python
        validate_only: Optional[bool]
        workspace_policy_change_request_v2: WorkspacePolicyChangeRequestV2
        ```
        validate_only: Validate the given policy payload without applying it
        workspace_policy_change_request_v2: See model WorkspacePolicyChangeRequestV2 for more information.

        ### Example:
        ```python
        PolicyApi(
            validate_only=True,
                        workspace_policy_change_request_v2=runai.WorkspacePolicyChangeRequestV2()
        )
        ```
        """

        # Body params:
        body_params = workspace_policy_change_request_v2

        # Query params:
        query_params = [
            ("validateOnly", validate_only),
        ]
        resource_path = f"/api/v2/policy/workspaces".replace("_", "-")
        method = "PATCH"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
            query_params=query_params,
        )
