from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class RegistryApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_registry(
        self,
        registry_creation_request: models.RegistryCreationRequest,
    ):
        r"""


        ### Description
        Create a registry asset.

        ### Parameters:
        ```python
        registry_creation_request: RegistryCreationRequest
        ```
        registry_creation_request: See model RegistryCreationRequest for more information.

        ### Example:
        ```python
        RegistryApi(
            registry_creation_request=runai.RegistryCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = registry_creation_request

        resource_path = f"/api/v1/asset/registries".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_registry(
        self,
        asset_id: str,
    ):
        r"""


        ### Description
        Delete a registry asset.

        ### Parameters:
        ```python
        asset_id: str
        ```
        asset_id: Unique identifier of the asset.

        ### Example:
        ```python
        RegistryApi(
            asset_id='asset_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/asset/registries/{asset_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_registry_by_id(
        self,
        asset_id: str,
    ):
        r"""


        ### Description
        Get a registry.

        ### Parameters:
        ```python
        asset_id: str
        ```
        asset_id: Unique identifier of the asset.

        ### Example:
        ```python
        RegistryApi(
            asset_id='asset_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/asset/registries/{asset_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_repositories(
        self,
        asset_id: str,
        search_name: Optional[str] = None,
    ):
        r"""


        ### Description
        Get the repositories in the registry.

        ### Parameters:
        ```python
        asset_id: str
        search_name: Optional[str]
        ```
        asset_id: Unique identifier of the asset.
        search_name: Filter results that contains searchName.

        ### Example:
        ```python
        RegistryApi(
            asset_id='asset_id_example',
                        search_name='search_name_example'
        )
        ```
        """

        # Query params:
        query_params = [
            ("searchName", search_name),
        ]
        resource_path = f"/api/v1/asset/registries/{asset_id}/repositories".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_repository_tags(
        self,
        asset_id: str,
        repository: str,
        search_name: Optional[str] = None,
    ):
        r"""


        ### Description
        Get the repositories tags in the registry.

        ### Parameters:
        ```python
        asset_id: str
        repository: Optional[str]
        search_name: Optional[str]
        ```
        asset_id: Unique identifier of the asset.
        repository: The repository name that its tags are requested.
        search_name: Filter results that contains searchName.

        ### Example:
        ```python
        RegistryApi(
            asset_id='asset_id_example',
                        repository='repository_example',
                        search_name='search_name_example'
        )
        ```
        """

        # Query params:
        query_params = [
            ("repository", repository),
            ("searchName", search_name),
        ]
        resource_path = (
            f"/api/v1/asset/registries/{asset_id}/repositories/tags".replace("_", "-")
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def list_registries(
        self,
        name: Optional[str] = None,
    ):
        r"""


        ### Description
        Get registries.

        ### Parameters:
        ```python
        name: Optional[str]
        ```
        name: Filter results by name.

        ### Example:
        ```python
        RegistryApi(
            name='name_example'
        )
        ```
        """

        # Query params:
        query_params = [
            ("name", name),
        ]
        resource_path = f"/api/v1/asset/registries".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def update_registry(
        self,
        asset_id: str,
        registry_update_request: models.RegistryUpdateRequest,
    ):
        r"""


        ### Description
        Update a registry asset.

        ### Parameters:
        ```python
        asset_id: str
        registry_update_request: RegistryUpdateRequest
        ```
        asset_id: Unique identifier of the asset.
        registry_update_request: See model RegistryUpdateRequest for more information.

        ### Example:
        ```python
        RegistryApi(
            asset_id='asset_id_example',
                        registry_update_request=runai.RegistryUpdateRequest()
        )
        ```
        """

        # Body params:
        body_params = registry_update_request

        resource_path = f"/api/v1/asset/registries/{asset_id}".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
