from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class ResearcherCommandLineInterfaceApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def get_binary(
        self,
        operating_system: str,
        architecture: str,
    ):
        r"""


        ### Description
        Download RunAI Researcher command line binary

        ### Parameters:
        ```python
        operating_system: str
        architecture: str
        ```
        operating_system: The operating system name.
        architecture: The architecture type.

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(
            operating_system='linux',
                        architecture='arm64'
        )
        ```
        """

        resource_path = (
            f"/api/v1/cli_exposer/dist/{operating_system}/{architecture}/runai".replace(
                "_", "-"
            )
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_installer_linux(
        self,
    ):
        r"""


        ### Description
        Download Linux installer script

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli_exposer/installer/linux".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_installer_linux_commands(
        self,
    ):
        r"""


        ### Description
        Get Linux installer script commands

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli_exposer/installer/linux/commands".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_installer_mac(
        self,
    ):
        r"""


        ### Description
        Download Mac installer script

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli_exposer/installer/mac".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_installer_mac_commands(
        self,
    ):
        r"""


        ### Description
        Get Mac installer script commands

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli_exposer/installer/mac/commands".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_installer_unix(
        self,
    ):
        r"""


        ### Description
        Download Unix installer script

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli_exposer/installer/unix".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_installer_unix_commands(
        self,
    ):
        r"""


        ### Description
        Get Unix installer script commands

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli_exposer/installer/unix/commands".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_installer_windows_commands(
        self,
    ):
        r"""


        ### Description
        Get Windows MSI installer script commands

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli_exposer/installer/windows/commands".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_manual_document(
        self,
        document_name: str,
    ):
        r"""


        ### Description
        Get CLI document by name

        ### Parameters:
        ```python
        document_name: str
        ```
        document_name: The manual document name.

        ### Example:
        ```python
        ResearcherCommandLineInterfaceApi(
            document_name='runai.md'
        )
        ```
        """

        resource_path = f"/api/v1/cli_exposer/docs/{document_name}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
