from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class ResearcherCommandLineInterfaceDeprecatedApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    @deprecated_message()
    def get_binary_deprecated(
        self,
        operating_system: str,
        architecture: str,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Download RunAI Researcher command line binary

        ### Parameters:
        ```python
        operating_system: str
        architecture: str
        ```
        operating_system: The operating system name.
        architecture: The architecture type.

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(
            operating_system='linux',
                        architecture='arm64'
        )
        ```
        """

        resource_path = (
            f"/api/v1/cli/dist/{operating_system}/{architecture}/runai".replace(
                "_", "-"
            )
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_installer_linux_commands_deprecated(
        self,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get Linux installer script commands

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli/installer/linux/commands".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_installer_linux_deprecated(
        self,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Download Linux installer script

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli/installer/linux".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_installer_mac_commands_deprecated(
        self,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get Mac installer script commands

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli/installer/mac/commands".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_installer_mac_deprecated(
        self,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Download Mac installer script

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli/installer/mac".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_installer_unix_commands_deprecated(
        self,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get Unix installer script commands

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli/installer/unix/commands".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_installer_unix_deprecated(
        self,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Download Unix installer script

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli/installer/unix".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_installer_windows_commands_deprecated(
        self,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get Windows MSI installer script commands

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(

        )
        ```
        """

        resource_path = f"/api/v1/cli/installer/windows/commands".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_manual_document_deprecated(
        self,
        document_name: str,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get CLI document by name

        ### Parameters:
        ```python
        document_name: str
        ```
        document_name: The manual document name.

        ### Example:
        ```python
        ResearcherCommandLineInterfaceDeprecatedApi(
            document_name='runai.md'
        )
        ```
        """

        resource_path = f"/api/v1/cli/docs/{document_name}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
