from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class RevisionsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def count_inference_workload_revisions(
        self,
        workload_id: str,
        deleted: Optional[bool] = None,
    ):
        r"""


        ### Description
        Get inference workload revisions count. [Experimental]

        ### Parameters:
        ```python
        workload_id: str
        deleted: Optional[bool]
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.
        deleted: Return only deleted resources when &#x60;true&#x60;.

        ### Example:
        ```python
        RevisionsApi(
            workload_id='workload_id_example',
                        deleted=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("deleted", deleted),
        ]
        resource_path = (
            f"/api/v1/workloads/inferences/{workload_id}/revisions/count".replace(
                "_", "-"
            )
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_inference_workload_revisions(
        self,
        workload_id: str,
        deleted: Optional[bool] = None,
    ):
        r"""


        ### Description
        Get inference workload revisions by id. [Experimental]

        ### Parameters:
        ```python
        workload_id: str
        deleted: Optional[bool]
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.
        deleted: Return only deleted resources when &#x60;true&#x60;.

        ### Example:
        ```python
        RevisionsApi(
            workload_id='workload_id_example',
                        deleted=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("deleted", deleted),
        ]
        resource_path = f"/api/v1/workloads/inferences/{workload_id}/revisions".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_revision(
        self,
        revision_id: str,
    ):
        r"""


        ### Description
        Get revision data. [Experimental]

        ### Parameters:
        ```python
        revision_id: str
        ```
        revision_id: The  Universally Unique Identifier (UUID) of the revision.

        ### Example:
        ```python
        RevisionsApi(
            revision_id='revision_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/inferences/revisions/{revision_id}".replace(
            "_", "-"
        )
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
