from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class StorageClassesApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def get_storage_classes(
        self,
        cluster_id: str,
        name: Optional[str] = None,
        include_none: Optional[bool] = None,
    ):
        r"""


        ### Description
        get a Storage Class/Classes for a given cluster

        ### Parameters:
        ```python
        cluster_id: Optional[str]
        name: Optional[str]
        include_none: Optional[bool]
        ```
        cluster_id: The id of the cluster
        name: filter by name
        include_none: Include runai-none storage class, which is used for static provisioning of PVC. In static provisioning storage is omitted.

        ### Example:
        ```python
        StorageClassesApi(
            cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        name='name_example',
                        include_none=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("clusterId", cluster_id),
            ("name", name),
            ("includeNone", include_none),
        ]
        resource_path = f"/api/v1/storage_classes".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_storage_classes_v2(
        self,
        cluster_id: str,
        name: Optional[str] = None,
        include_none: Optional[bool] = None,
    ):
        r"""


        ### Description
        get a Storage Class/Classes for a given cluster

        ### Parameters:
        ```python
        cluster_id: Optional[str]
        name: Optional[str]
        include_none: Optional[bool]
        ```
        cluster_id: The id of the cluster
        name: filter by name
        include_none: Include runai-none storage class, which is used for static provisioning of PVC. In static provisioning storage is omitted.

        ### Example:
        ```python
        StorageClassesApi(
            cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        name='name_example',
                        include_none=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("clusterId", cluster_id),
            ("name", name),
            ("includeNone", include_none),
        ]
        resource_path = f"/api/v2/storage_classes".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    @deprecated_message()
    def v1_get_storage_classes(
        self,
        uuid: str,
        include_none: Optional[bool] = None,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get all storageClasses from a cluster.

        ### Parameters:
        ```python
        uuid: str
        include_none: Optional[bool]
        ```
        uuid: Unique identifier of the cluster
        include_none: Include runai-none storage class to be able to create PVCs without a storage class

        ### Example:
        ```python
        StorageClassesApi(
            uuid='uuid_example',
                        include_none=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("includeNone", include_none),
        ]
        resource_path = f"/v1/k8s/clusters/{uuid}/storage_classes".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )
