from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class SubscriptionsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_subscription(
        self,
        subscription: Optional[models.Subscription] = None,
    ):
        r"""


        ### Description
        Create user subscription

        ### Parameters:
        ```python
        subscription: Subscription
        ```
        subscription: See model Subscription for more information.

        ### Example:
        ```python
        SubscriptionsApi(
            subscription=runai.Subscription()
        )
        ```
        """

        # Body params:
        body_params = subscription

        resource_path = f"/api/v1/subscriptions".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_subscription(
        self,
        id: str,
    ):
        r"""


        ### Description
        Delete user subscription

        ### Parameters:
        ```python
        id: str
        ```
        id: Subscription id

        ### Example:
        ```python
        SubscriptionsApi(
            id='id_example'
        )
        ```
        """

        resource_path = f"/api/v1/subscriptions/{id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_my_subscriptions(
        self,
    ):
        r"""


        ### Description
        Get current users subscriptions

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        SubscriptionsApi(

        )
        ```
        """

        resource_path = f"/api/v1/subscriptions".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def update_subscription(
        self,
        id: str,
        subscription_for_put: Optional[models.SubscriptionForPut] = None,
    ):
        r"""


        ### Description
        Update user subscription

        ### Parameters:
        ```python
        id: str
        subscription_for_put: SubscriptionForPut
        ```
        id: Subscription id
        subscription_for_put: See model SubscriptionForPut for more information.

        ### Example:
        ```python
        SubscriptionsApi(
            id='id_example',
                        subscription_for_put=runai.SubscriptionForPut()
        )
        ```
        """

        # Body params:
        body_params = subscription_for_put

        resource_path = f"/api/v1/subscriptions/{id}".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
