from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class TemplateApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_template(
        self,
        workload_template_creation_request: Optional[
            models.WorkloadTemplateCreationRequest
        ] = None,
    ):
        r"""


        ### Description
        Create a template.

        ### Parameters:
        ```python
        workload_template_creation_request: WorkloadTemplateCreationRequest
        ```
        workload_template_creation_request: See model WorkloadTemplateCreationRequest for more information.

        ### Example:
        ```python
        TemplateApi(
            workload_template_creation_request=runai.WorkloadTemplateCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = workload_template_creation_request

        resource_path = f"/api/v1/asset/workload_template".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_template_by_id(
        self,
        asset_id: str,
    ):
        r"""


        ### Description
        Delete a template.

        ### Parameters:
        ```python
        asset_id: str
        ```
        asset_id: Unique identifier of the asset.

        ### Example:
        ```python
        TemplateApi(
            asset_id='asset_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/asset/workload_template/{asset_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_template_by_id(
        self,
        asset_id: str,
    ):
        r"""


        ### Description
        Get a template.

        ### Parameters:
        ```python
        asset_id: str
        ```
        asset_id: Unique identifier of the asset.

        ### Example:
        ```python
        TemplateApi(
            asset_id='asset_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/asset/workload_template/{asset_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def list_templates(
        self,
        name: Optional[str] = None,
        scope: Optional[str] = None,
        project_id: Optional[int] = None,
        department_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        distributed_framework: Optional[str] = None,
        is_distributed: Optional[bool] = None,
        is_training: Optional[bool] = None,
        is_workspace: Optional[bool] = None,
    ):
        r"""


        ### Description
        List templates.

        ### Parameters:
        ```python
        name: Optional[str]
        scope: Optional[str]
        project_id: Optional[int]
        department_id: Optional[str]
        cluster_id: Optional[str]
        distributed_framework: Optional[str]
        is_distributed: Optional[bool]
        is_training: Optional[bool]
        is_workspace: Optional[bool]
        ```
        name: Filter results by name.
        scope: Filter results by scope.
        project_id: Filter results by project id. If scope filter is project, only assets from the specific project will be included in the response. Otherwise, the response will include project, department, cluster, tenant and system assets.
        department_id: Filter results by department id. If scope filter is department, only assets from the specific department will be included in the response. Otherwise, the response will include department, cluster, tenant and system assets.
        cluster_id: Filter results by Universally Unique Identifier (UUID) of the cluster. If scope filter is cluster, only assets from the specific cluster will be included in the response. Otherwise, the response will include cluster, tenant and system assets.
        distributed_framework: Filter results to workload of type distributed and distributedFramework.
        is_distributed: Filter results to workload of type distributed.
        is_training: Filter results to workload of type training.
        is_workspace: Filter results to workload of type workspace.

        ### Example:
        ```python
        TemplateApi(
            name='name_example',
                        scope='scope_example',
                        project_id=56,
                        department_id='1',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        distributed_framework='distributed_framework_example',
                        is_distributed=True,
                        is_training=True,
                        is_workspace=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("name", name),
            ("scope", scope),
            ("projectId", project_id),
            ("departmentId", department_id),
            ("clusterId", cluster_id),
            ("distributedFramework", distributed_framework),
            ("isDistributed", is_distributed),
            ("isTraining", is_training),
            ("isWorkspace", is_workspace),
        ]
        resource_path = f"/api/v1/asset/workload_template".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def update_template(
        self,
        asset_id: str,
        workload_template_update_request: Optional[
            models.WorkloadTemplateUpdateRequest
        ] = None,
    ):
        r"""


        ### Description
        Update a template.

        ### Parameters:
        ```python
        asset_id: str
        workload_template_update_request: WorkloadTemplateUpdateRequest
        ```
        asset_id: Unique identifier of the asset.
        workload_template_update_request: See model WorkloadTemplateUpdateRequest for more information.

        ### Example:
        ```python
        TemplateApi(
            asset_id='asset_id_example',
                        workload_template_update_request=runai.WorkloadTemplateUpdateRequest()
        )
        ```
        """

        # Body params:
        body_params = workload_template_update_request

        resource_path = f"/api/v1/asset/workload_template/{asset_id}".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
