from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class TokensApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    @deprecated_message()
    def app_token(
        self,
        app_token_request: Optional[models.AppTokenRequest] = None,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        get application token

        ### Parameters:
        ```python
        app_token_request: AppTokenRequest
        ```
        app_token_request: See model AppTokenRequest for more information.

        ### Example:
        ```python
        TokensApi(
            app_token_request=runai.AppTokenRequest()
        )
        ```
        """

        # Body params:
        body_params = app_token_request

        resource_path = f"/v1/k8s/auth/oauth/apptoken".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def grant_token(
        self,
        token_request: Optional[models.TokenRequest] = None,
    ):
        r"""


        ### Description
        Create a token

        ### Parameters:
        ```python
        token_request: TokenRequest
        ```
        token_request: See model TokenRequest for more information.

        ### Example:
        ```python
        TokensApi(
            token_request={"grantType":"client_credentials","clientID":"clientID","clientSecret":"clientSecret"}
        )
        ```
        """

        # Body params:
        body_params = token_request

        resource_path = f"/api/v1/token".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
