from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class TrainingsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_training1(
        self,
        training_creation_request: Optional[models.TrainingCreationRequest] = None,
    ):
        r"""


        ### Description
        Create a training.

        ### Parameters:
        ```python
        training_creation_request: TrainingCreationRequest
        ```
        training_creation_request: See model TrainingCreationRequest for more information.

        ### Example:
        ```python
        TrainingsApi(
            training_creation_request=runai.TrainingCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = training_creation_request

        resource_path = f"/api/v1/workloads/trainings".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_training(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Delete a training.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        TrainingsApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/trainings/{workload_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_training(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Get training data.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        TrainingsApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/trainings/{workload_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def resume_training(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Resume a training.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        TrainingsApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/trainings/{workload_id}/resume".replace(
            "_", "-"
        )
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def suspend_training(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Suspend a training.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        TrainingsApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/trainings/{workload_id}/suspend".replace(
            "_", "-"
        )
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
