from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class UserApplicationsApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_user_application(
        self,
        user_app_creation_request: models.UserAppCreationRequest,
    ):
        r"""


        ### Description
        Create a user application.

        ### Parameters:
        ```python
        user_app_creation_request: UserAppCreationRequest
        ```
        user_app_creation_request: Application object to create

        ### Example:
        ```python
        UserApplicationsApi(
            user_app_creation_request=runai.UserAppCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = user_app_creation_request

        resource_path = f"/api/v1/user_applications".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_user_application_by_id(
        self,
        app_id: str,
    ):
        r"""


        ### Description
        Delete a user application byid.

        ### Parameters:
        ```python
        app_id: str
        ```
        app_id: The application id to retrieve

        ### Example:
        ```python
        UserApplicationsApi(
            app_id='app_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/user_applications/{app_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def delete_user_application_by_id_administration(
        self,
        app_id: str,
    ):
        r"""


        ### Description
        Delete a user application by id for adminstrations.

        ### Parameters:
        ```python
        app_id: str
        ```
        app_id: The application id to retrieve

        ### Example:
        ```python
        UserApplicationsApi(
            app_id='app_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/administration/user_applications/{app_id}".replace(
            "_", "-"
        )
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_user_application_by_id(
        self,
        app_id: str,
    ):
        r"""


        ### Description
        Get user application by id.

        ### Parameters:
        ```python
        app_id: str
        ```
        app_id: The application id to retrieve

        ### Example:
        ```python
        UserApplicationsApi(
            app_id='app_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/user_applications/{app_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_user_applications(
        self,
    ):
        r"""


        ### Description
        Get a list of users applications.

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        UserApplicationsApi(

        )
        ```
        """

        resource_path = f"/api/v1/user_applications".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_user_applications_administration(
        self,
        client_id: Optional[str] = None,
        created_by: Optional[str] = None,
    ):
        r"""


        ### Description
        Get a list of all users applications.

        ### Parameters:
        ```python
        client_id: Optional[str]
        created_by: Optional[str]
        ```
        client_id: Filter results by clientId
        created_by: Filter results by creatdBy

        ### Example:
        ```python
        UserApplicationsApi(
            client_id='3434c-12323ab-4ce2ea6-b44fc-db344d',
                        created_by='test@run.ai'
        )
        ```
        """

        # Query params:
        query_params = [
            ("clientId", client_id),
            ("createdBy", created_by),
        ]
        resource_path = f"/api/v1/administration/user_applications".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def regenerate_user_application_secret(
        self,
        app_id: str,
    ):
        r"""


        ### Description
        Regenerate a user application secret.

        ### Parameters:
        ```python
        app_id: str
        ```
        app_id: The application id to retrieve

        ### Example:
        ```python
        UserApplicationsApi(
            app_id='app_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/user_applications/{app_id}/secret".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
