from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class UsersApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def change_user_password(
        self,
        user_change_password_request: models.UserChangePasswordRequest,
    ):
        r"""


        ### Description
        change user password

        ### Parameters:
        ```python
        user_change_password_request: UserChangePasswordRequest
        ```
        user_change_password_request: Password to change

        ### Example:
        ```python
        UsersApi(
            user_change_password_request=runai.UserChangePasswordRequest()
        )
        ```
        """

        # Body params:
        body_params = user_change_password_request

        resource_path = f"/api/v1/me/password".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def count_users(
        self,
        filter_by: Optional[List[str]] = None,
        search: Optional[str] = None,
    ):
        r"""


        ### Description
        Count users

        ### Parameters:
        ```python
        filter_by: Optional[List[str]]
        search: Optional[str]
        ```
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains. Dates are in ISO 8601 timestamp format and available for operators &lt;&#x3D;, &gt;&#x3D; and &#x3D;&#x3D;.
        search: Filter results by a free text search.

        ### Example:
        ```python
        UsersApi(
            filter_by=['[\"username=@test,lastLogin>=2024-09-24T00:00:00.00Z,isLocal==false\"]'],
                        search='test@run'
        )
        ```
        """

        # Query params:
        query_params = [
            ("filterBy", filter_by),
            ("search", search),
        ]
        resource_path = f"/api/v1/users/count".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    @deprecated_message()
    def create_group(
        self,
        group_creation_request: models.GroupCreationRequest,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Create a new group.

        ### Parameters:
        ```python
        group_creation_request: GroupCreationRequest
        ```
        group_creation_request: See model GroupCreationRequest for more information.

        ### Example:
        ```python
        UsersApi(
            group_creation_request=runai.GroupCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = group_creation_request

        resource_path = f"/v1/k8s/groups".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    @deprecated_message()
    def create_user(
        self,
        user_creation_request: models.UserCreationRequest,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Create a new user.

        ### Parameters:
        ```python
        user_creation_request: UserCreationRequest
        ```
        user_creation_request: See model UserCreationRequest for more information.

        ### Example:
        ```python
        UsersApi(
            user_creation_request=runai.UserCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = user_creation_request

        resource_path = f"/v1/k8s/users".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def create_user_0(
        self,
        user_creation_request1: models.UserCreationRequest1,
    ):
        r"""


        ### Description
        Create a local user.

        ### Parameters:
        ```python
        user_creation_request1: UserCreationRequest1
        ```
        user_creation_request1: User object to create

        ### Example:
        ```python
        UsersApi(
            user_creation_request1=runai.UserCreationRequest1()
        )
        ```
        """

        # Body params:
        body_params = user_creation_request1

        resource_path = f"/api/v1/users".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    @deprecated_message()
    def delete_group_by_name(
        self,
        group_name: str,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Delete a group.

        ### Parameters:
        ```python
        group_name: str
        ```
        group_name: See model str for more information.

        ### Example:
        ```python
        UsersApi(
            group_name='group1'
        )
        ```
        """

        resource_path = f"/v1/k8s/groups/{group_name}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def delete_user_by_id(
        self,
        user_id: str,
        users_type: Optional[List[models.UserType]] = None,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Delete a user.

        ### Parameters:
        ```python
        user_id: str
        users_type: Optional[models.List[UserType]]
        ```
        user_id: See model str for more information.
        users_type: Available only when SSO enabled

        ### Example:
        ```python
        UsersApi(
            user_id='user_id_example',
                        users_type=[runai.UserType()]
        )
        ```
        """

        # Query params:
        query_params = [
            ("usersType", users_type),
        ]
        resource_path = f"/v1/k8s/users/{user_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def delete_user_by_id_0(
        self,
        user_id: str,
    ):
        r"""


        ### Description
        Delete a user by id.

        ### Parameters:
        ```python
        user_id: str
        ```
        user_id: The id of the user

        ### Example:
        ```python
        UsersApi(
            user_id='user_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/users/{user_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def ge_group_by_name(
        self,
        group_name: str,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get group details.

        ### Parameters:
        ```python
        group_name: str
        ```
        group_name: See model str for more information.

        ### Example:
        ```python
        UsersApi(
            group_name='group1'
        )
        ```
        """

        resource_path = f"/v1/k8s/groups/{group_name}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_groups(
        self,
        roles: Optional[List[models.Role]] = None,
        only_created_by_me: Optional[bool] = None,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get groups list.

        ### Parameters:
        ```python
        roles: Optional[models.List[Role]]
        only_created_by_me: Optional[bool]
        ```
        roles: Filter the returned entities to only those with the required role
        only_created_by_me: Filter the returned entities to only those that created by the requesting subject

        ### Example:
        ```python
        UsersApi(
            roles=[runai.Role()],
                        only_created_by_me=True
        )
        ```
        """

        # Query params:
        query_params = [
            ("roles", roles),
            ("onlyCreatedByMe", only_created_by_me),
        ]
        resource_path = f"/v1/k8s/groups".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    @deprecated_message()
    def get_roles(
        self,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get all possible permissions.

        ### Parameters:
        ```python
        ```

        ### Example:
        ```python
        UsersApi(

        )
        ```
        """

        resource_path = f"/v1/k8s/users/roles".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_user_by_id(
        self,
        user_id: str,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get user details.

        ### Parameters:
        ```python
        user_id: str
        ```
        user_id: See model str for more information.

        ### Example:
        ```python
        UsersApi(
            user_id='user_id_example'
        )
        ```
        """

        resource_path = f"/v1/k8s/users/{user_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_user_by_id_0(
        self,
        user_id: str,
    ):
        r"""


        ### Description
        Get a user by id.

        ### Parameters:
        ```python
        user_id: str
        ```
        user_id: The id of the user

        ### Example:
        ```python
        UsersApi(
            user_id='user_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/users/{user_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_user_roles(
        self,
        user_id: str,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get user permissions.

        ### Parameters:
        ```python
        user_id: str
        ```
        user_id: See model str for more information.

        ### Example:
        ```python
        UsersApi(
            user_id='user_id_example'
        )
        ```
        """

        resource_path = f"/v1/k8s/users/{user_id}/roles".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def get_users(
        self,
        roles: Optional[List[models.Role]] = None,
        only_created_by_me: Optional[bool] = None,
        users_type: Optional[List[models.UserType]] = None,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Get users list.

        ### Parameters:
        ```python
        roles: Optional[models.List[Role]]
        only_created_by_me: Optional[bool]
        users_type: Optional[models.List[UserType]]
        ```
        roles: Filter the returned entities to only those with the required role
        only_created_by_me: Filter the returned entities to only those that created by the requesting subject
        users_type: Available only when SSO enabled

        ### Example:
        ```python
        UsersApi(
            roles=[runai.Role()],
                        only_created_by_me=True,
                        users_type=[runai.UserType()]
        )
        ```
        """

        # Query params:
        query_params = [
            ("roles", roles),
            ("onlyCreatedByMe", only_created_by_me),
            ("usersType", users_type),
        ]
        resource_path = f"/v1/k8s/users".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def get_users_0(
        self,
        filter: Optional[str] = None,
        filter_by: Optional[List[str]] = None,
        sort_by: Optional[models.UsersFilterSortFields] = None,
        sort_order: Optional[str] = None,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        search: Optional[str] = None,
    ):
        r"""


        ### Description
        Get users.

        ### Parameters:
        ```python
        filter: Optional[str]
        filter_by: Optional[List[str]]
        sort_by: Optional[models.UsersFilterSortFields]
        sort_order: Optional[str]
        offset: Optional[int]
        limit: Optional[int]
        search: Optional[str]
        ```
        filter: Filter results by user attribute.
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains. Dates are in ISO 8601 timestamp format and available for operators &lt;&#x3D;, &gt;&#x3D; and &#x3D;&#x3D;.
        sort_by: Sort results by a parameters.
        sort_order: Sort results in descending or ascending order. - Default: asc
        offset: The offset of the first item returned in the collection.
        limit: The maximum number of entries to return. - Default: 500
        search: Filter results by a free text search.

        ### Example:
        ```python
        UsersApi(
            filter='runai.is_local:true',
                        filter_by=['[\"username=@test,lastLogin>=2024-09-24T00:00:00.00Z,isLocal==false\"]'],
                        sort_by=runai.UsersFilterSortFields(),
                        sort_order=asc,
                        offset=100,
                        limit=500,
                        search='test@run'
        )
        ```
        """

        # Query params:
        query_params = [
            ("filter", filter),
            ("filterBy", filter_by),
            ("sortBy", sort_by),
            ("sortOrder", sort_order),
            ("offset", offset),
            ("limit", limit),
            ("search", search),
        ]
        resource_path = f"/api/v1/users".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )

    def logout_user(
        self,
        user_id: str,
    ):
        r"""


        ### Description
        Logout a user.

        ### Parameters:
        ```python
        user_id: str
        ```
        user_id: The id of the user

        ### Example:
        ```python
        UsersApi(
            user_id='user_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/users/{user_id}/logout".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def reset_user_password(
        self,
        user_id: str,
    ):
        r"""


        ### Description
        Reset a user&#39;s password.

        ### Parameters:
        ```python
        user_id: str
        ```
        user_id: The id of the user

        ### Example:
        ```python
        UsersApi(
            user_id='user_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/users/{user_id}/password".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    @deprecated_message()
    def update_group_by_name(
        self,
        group_name: str,
        group_with_name: models.GroupWithName,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Update group details.

        ### Parameters:
        ```python
        group_name: str
        group_with_name: GroupWithName
        ```
        group_name: See model str for more information.
        group_with_name: See model GroupWithName for more information.

        ### Example:
        ```python
        UsersApi(
            group_name='group1',
                        group_with_name=runai.GroupWithName()
        )
        ```
        """

        # Body params:
        body_params = group_with_name

        resource_path = f"/v1/k8s/groups/{group_name}".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    @deprecated_message()
    def update_user_by_id(
        self,
        user_id: str,
        user1: models.User1,
    ):
        r"""
        ## Deprecated endpoint, consider alternative method

        ### Description
        Update user details.

        ### Parameters:
        ```python
        user_id: str
        user1: User1
        ```
        user_id: See model str for more information.
        user1: See model User1 for more information.

        ### Example:
        ```python
        UsersApi(
            user_id='user_id_example',
                        user1=runai.User1()
        )
        ```
        """

        # Body params:
        body_params = user1

        resource_path = f"/v1/k8s/users/{user_id}".replace("_", "-")
        method = "PUT"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
