from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class WorkloadsBatchApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def batch_workloads(
        self,
        workload_batch: Optional[models.WorkloadBatch] = None,
    ):
        r"""


        ### Description
        Workload batch operations.

        ### Parameters:
        ```python
        workload_batch: WorkloadBatch
        ```
        workload_batch: See model WorkloadBatch for more information.

        ### Example:
        ```python
        WorkloadsBatchApi(
            workload_batch=runai.WorkloadBatch()
        )
        ```
        """

        # Body params:
        body_params = workload_batch

        resource_path = f"/api/v1/workloads/batch".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )
