from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class WorkloadsPrioritiesApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def get_workload_priorities(
        self,
        sort_order: Optional[str] = None,
        sort_by: Optional[str] = None,
        filter_by: Optional[List[str]] = None,
    ):
        r"""


        ### Description
        Get workload priorities.

        ### Parameters:
        ```python
        sort_order: Optional[str]
        sort_by: Optional[str]
        filter_by: Optional[List[str]]
        ```
        sort_order: Sort results in descending or ascending order. - Default: asc
        sort_by: Defines the field to sort the results by
        filter_by: Filter results by a parameter. Use the format field-name operator value. Operators are &#x3D;&#x3D; Equals, !&#x3D; Not equals, &lt;&#x3D; Less than or equal, &gt;&#x3D; Greater than or equal, &#x3D;@ contains, !@ Does not contains, &#x3D;^ Starts with and &#x3D;$ Ends with. Dates are in ISO 8601 timestamp format and available for operators &#x3D;&#x3D;, !&#x3D;, &lt;&#x3D; and &gt;&#x3D;

        ### Example:
        ```python
        WorkloadsPrioritiesApi(
            sort_order=asc,
                        sort_by='sort_by_example',
                        filter_by=['[\"name!=some-name\"]']
        )
        ```
        """

        # Query params:
        query_params = [
            ("sortOrder", sort_order),
            ("sortBy", sort_by),
            ("filterBy", filter_by),
        ]
        resource_path = f"/api/v1/workload_priorities".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path, method=method, query_params=query_params
        )
