from typing import Optional, List
from datetime import datetime

from runai import models
from runai.api.runai_api_service import RunaiAPIService, deprecated_message


class WorkspacesApi(RunaiAPIService):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        self._api_client = api_client

    def create_workspace1(
        self,
        workspace_creation_request: Optional[models.WorkspaceCreationRequest] = None,
    ):
        r"""


        ### Description
        Create a workspace.

        ### Parameters:
        ```python
        workspace_creation_request: WorkspaceCreationRequest
        ```
        workspace_creation_request: See model WorkspaceCreationRequest for more information.

        ### Example:
        ```python
        WorkspacesApi(
            workspace_creation_request=runai.WorkspaceCreationRequest()
        )
        ```
        """

        # Body params:
        body_params = workspace_creation_request

        resource_path = f"/api/v1/workloads/workspaces".replace("_", "-")
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
            body=body_params,
        )

    def delete_workspace(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Delete a workspace.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        WorkspacesApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/workspaces/{workload_id}".replace("_", "-")
        method = "DELETE"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def get_workspace(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Get workspace data.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        WorkspacesApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/workspaces/{workload_id}".replace("_", "-")
        method = "GET"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def resume_workspace(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Resume a workspace.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        WorkspacesApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/workspaces/{workload_id}/resume".replace(
            "_", "-"
        )
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )

    def suspend_workspace(
        self,
        workload_id: str,
    ):
        r"""


        ### Description
        Suspend a workspace.

        ### Parameters:
        ```python
        workload_id: str
        ```
        workload_id: The  Universally Unique Identifier (UUID) of the workload.

        ### Example:
        ```python
        WorkspacesApi(
            workload_id='workload_id_example'
        )
        ```
        """

        resource_path = f"/api/v1/workloads/workspaces/{workload_id}/suspend".replace(
            "_", "-"
        )
        method = "POST"
        return self._api_client.call_api(
            resource_path=resource_path,
            method=method,
        )
