# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.scope_type import ScopeType
from runai.models.subject_type import SubjectType
from typing import Optional, Set
from typing_extensions import Self


class AccessRuleCreationFields(BaseModel):
    """
    Pydantic class model representing AccessRuleCreationFields.

    Parameters:
        ```python
        subject_id: str
        subject_type: SubjectType
        role_id: int
        scope_id: str
        scope_type: ScopeType
        cluster_id: str
        ```
        subject_id: The unique identifier of the subject (e.g., user, group, or app).
        subject_type: See model SubjectType for more information.
        role_id: The numeric ID of the assigned role.
        scope_id: The unique identifier of the scope.
        scope_type: See model ScopeType for more information.
        cluster_id: The id of the cluster.
    Example:
        ```python
        AccessRuleCreationFields(
            subject_id='user@run.ai',
                        subject_type='user',
                        role_id=53142648,
                        scope_id='a418ed33-9399-48c0-a890-122cadd13bfd',
                        scope_type='system',
                        cluster_id='71f69d83-ba66-4822-adf5-55ce55efd210'
        )
        ```
    """  # noqa: E501

    subject_id: StrictStr = Field(
        description="The unique identifier of the subject (e.g., user, group, or app).",
        alias="subjectId",
    )
    subject_type: SubjectType = Field(alias="subjectType")
    role_id: StrictInt = Field(
        description="The numeric ID of the assigned role.", alias="roleId"
    )
    scope_id: StrictStr = Field(
        description="The unique identifier of the scope.", alias="scopeId"
    )
    scope_type: ScopeType = Field(alias="scopeType")
    cluster_id: Optional[StrictStr] = Field(
        default=None, description="The id of the cluster.", alias="clusterId"
    )
    __properties: ClassVar[List[str]] = [
        "subjectId",
        "subjectType",
        "roleId",
        "scopeId",
        "scopeType",
        "clusterId",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccessRuleCreationFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccessRuleCreationFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "subjectId": obj.get("subjectId"),
                "subjectType": obj.get("subjectType"),
                "roleId": obj.get("roleId"),
                "scopeId": obj.get("scopeId"),
                "scopeType": obj.get("scopeType"),
                "clusterId": obj.get("clusterId"),
            }
        )
        return _obj
