# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.access_rule_scopes_inner import AccessRuleScopesInner
from runai.models.access_rule_subjects_inner import AccessRuleSubjectsInner
from typing import Optional, Set
from typing_extensions import Self


class AccessRulesBatchCreateFieldsPayload(BaseModel):
    """
    Pydantic class model representing An array of access rule objects, each containing the role, subject, cluster, and scope to apply..

    Parameters:
        ```python
        role_id: int
        cluster_id: str
        subjects: List[AccessRuleSubjectsInner]
        scopes: List[AccessRuleScopesInner]
        ```
        role_id: The numeric ID of the role to assign (e.g., admin, viewer).
        cluster_id: The id of the cluster.
        subjects: subjects for the access rules. must have at least one value
        scopes: scopes for the access rules. must have at least one value
    Example:
        ```python
        AccessRulesBatchCreateFieldsPayload(
            role_id=53142648,
                        cluster_id='71f69d83-ba66-4822-adf5-55ce55efd210',
                        subjects=[
                    runai.models.access_rule_subjects_inner.AccessRuleSubjects_inner(
                        subject_id = 'user@run.ai',
                        subject_type = null, )
                    ],
                        scopes=[
                    runai.models.access_rule_scopes_inner.AccessRuleScopes_inner(
                        scope_id = '',
                        scope_type = null, )
                    ]
        )
        ```
    """  # noqa: E501

    role_id: StrictInt = Field(
        description="The numeric ID of the role to assign (e.g., admin, viewer).",
        alias="roleId",
    )
    cluster_id: Optional[StrictStr] = Field(
        default=None, description="The id of the cluster.", alias="clusterId"
    )
    subjects: List[AccessRuleSubjectsInner] = Field(
        description="subjects for the access rules. must have at least one value"
    )
    scopes: List[AccessRuleScopesInner] = Field(
        description="scopes for the access rules. must have at least one value"
    )
    __properties: ClassVar[List[str]] = ["roleId", "clusterId", "subjects", "scopes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccessRulesBatchCreateFieldsPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in subjects (list)
        _items = []
        if self.subjects:
            for _item_subjects in self.subjects:
                if _item_subjects:
                    _items.append(_item_subjects.to_dict())
            _dict["subjects"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scopes (list)
        _items = []
        if self.scopes:
            for _item_scopes in self.scopes:
                if _item_scopes:
                    _items.append(_item_scopes.to_dict())
            _dict["scopes"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccessRulesBatchCreateFieldsPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "roleId": obj.get("roleId"),
                "clusterId": obj.get("clusterId"),
                "subjects": (
                    [
                        AccessRuleSubjectsInner.from_dict(_item)
                        for _item in obj["subjects"]
                    ]
                    if obj.get("subjects") is not None
                    else None
                ),
                "scopes": (
                    [AccessRuleScopesInner.from_dict(_item) for _item in obj["scopes"]]
                    if obj.get("scopes") is not None
                    else None
                ),
            }
        )
        return _obj
